structure(list(method = "GET", url = "https://api.us.socrata.com/api/catalog/v1?limit=10&only=dataset&search_context=data.cityofchicago.org&tags=cta&tags=public%20transit", 
    status_code = 200L, headers = structure(list(Server = "nginx", 
        Date = "Tue, 22 Jul 2025 20:42:00 GMT", `Content-Type` = "application/json;charset=utf-8", 
        `Transfer-Encoding` = "chunked", Connection = "keep-alive", 
        `Access-Control-Allow-Origin` = "*", Vary = "Accept-Encoding", 
        `Content-Encoding` = "gzip", `X-Socrata-Region` = "aws-us-east-1-fedramp-prod", 
        `Strict-Transport-Security` = "max-age=31536000; includeSubDomains"), class = "httr2_headers"), 
    body = charToRaw("{\n  \"results\" :\n    [\n      {\n        \"resource\" :\n          {\n            \"name\" : \"CTA - Ridership - Daily Boarding Totals\",\n            \"id\" : \"6iiy-9s97\",\n            \"resource_name\" : null,\n            \"parent_fxf\" : [],\n            \"description\" : \"This dataset shows systemwide boardings for both bus and rail services provided by CTA, dating back to 2001. Daytypes are as follows: W = Weekday, A = Saturday, U = Sunday/Holiday. See attached readme file for information on how these numbers are calculated.\",\n            \"attribution\" : \"Chicago Transit Authority\",\n            \"attribution_link\" : \"http://www.transitchicago.com\",\n            \"contact_email\" : null,\n            \"type\" : \"dataset\",\n            \"updatedAt\" : \"2025-06-30T18:44:33.000Z\",\n            \"createdAt\" : \"2011-08-12T15:40:31.000Z\",\n            \"metadata_updated_at\" : \"2025-06-30T18:44:32.000Z\",\n            \"data_updated_at\" : \"2025-06-30T18:44:33.000Z\",\n            \"page_views\" :\n              {\n                \"page_views_last_week\" : 441,\n                \"page_views_last_month\" : 2131,\n                \"page_views_total\" : 108062,\n                \"page_views_last_week_log\" : 8.787902559391432,\n                \"page_views_last_month_log\" : 11.057991722759176,\n                \"page_views_total_log\" : 16.721513113569625\n              },\n            \"columns_name\" :\n              [\n                \"total_rides\",\n                \"bus\",\n                \"service_date\",\n                \"day_type\",\n                \"rail_boardings\"\n              ],\n            \"columns_field_name\" :\n              [\n                \"total_rides\",\n                \"bus\",\n                \"service_date\",\n                \"day_type\",\n                \"rail_boardings\"\n              ],\n            \"columns_datatype\" :\n              [ \"Number\", \"Number\", \"Calendar date\", \"Text\", \"Number\" ],\n            \"columns_description\" : [ \"\", \"\", \"\", \"\", \"\" ],\n            \"columns_format\" :\n              [\n                {},\n                {},\n                { \"view\" : \"date\", \"align\" : \"left\", \"aggregate\" : \"count\" },\n                {},\n                {}\n              ],\n            \"download_count\" : 38841,\n            \"provenance\" : \"official\",\n            \"lens_view_type\" : \"tabular\",\n            \"lens_display_type\" : \"table\",\n            \"locked\" : false,\n            \"blob_mime_type\" : null,\n            \"hide_from_data_json\" : false,\n            \"publication_date\" : \"2025-04-29T16:35:04.000Z\"\n          },\n        \"classification\" :\n          {\n            \"categories\" : [],\n            \"tags\" : [],\n            \"domain_category\" : \"Transportation\",\n            \"domain_tags\" : [ \"cta\", \"public transit\", \"ridership\" ],\n            \"domain_metadata\" :\n              [\n                {\n                  \"key\" : \"Metadata_Data-Owner\",\n                  \"value\" : \"Chicago Transit Authority \"\n                }\n              ]\n          },\n        \"metadata\" :\n          {\n            \"domain\" : \"data.cityofchicago.org\",\n            \"license\" : \"See Terms of Use\"\n          },\n        \"permalink\" : \"https://data.cityofchicago.org/d/6iiy-9s97\",\n        \"link\" : \"https://data.cityofchicago.org/Transportation/CTA-Ridership-Daily-Boarding-Totals/6iiy-9s97\",\n        \"owner\" :\n          {\n            \"id\" : \"6bsn-5494\",\n            \"user_type\" : \"interactive\",\n            \"display_name\" : \"CTA\"\n          },\n        \"creator\" :\n          {\n            \"id\" : \"6bsn-5494\",\n            \"user_type\" : \"interactive\",\n            \"display_name\" : \"CTA\"\n          }\n      },\n      {\n        \"resource\" :\n          {\n            \"name\" : \"CTA - List of CTA Datasets\",\n            \"id\" : \"pnau-cf66\",\n            \"resource_name\" : null,\n            \"parent_fxf\" : [],\n            \"description\" : \"This lists datasets published by CTA in the City of Chicago Data Portal.\",\n            \"attribution\" : \"Chicago Transit Authority\",\n            \"attribution_link\" : \"http://www.transitchicago.com\",\n            \"contact_email\" : null,\n            \"type\" : \"dataset\",\n            \"updatedAt\" : \"2017-05-17T16:26:45.000Z\",\n            \"createdAt\" : \"2011-08-12T00:02:54.000Z\",\n            \"metadata_updated_at\" : \"2017-05-17T16:26:45.000Z\",\n            \"data_updated_at\" : \"2017-05-17T16:26:34.000Z\",\n            \"page_views\" :\n              {\n                \"page_views_last_week\" : 48,\n                \"page_views_last_month\" : 191,\n                \"page_views_total\" : 74124,\n                \"page_views_last_week_log\" : 5.614709844115208,\n                \"page_views_last_month_log\" : 7.584962500721156,\n                \"page_views_total_log\" : 16.177672579208092\n              },\n            \"columns_name\" : [ \"Link\", \"Description\" ],\n            \"columns_field_name\" : [ \"link\", \"description\" ],\n            \"columns_datatype\" : [ \"URL\", \"Text\" ],\n            \"columns_description\" : [ \"\", \"\" ],\n            \"columns_format\" :\n              [\n                { \"align\" : \"left\", \"aggregate\" : \"count\" },\n                { \"align\" : \"left\" }\n              ],\n            \"download_count\" : 5785,\n            \"provenance\" : \"official\",\n            \"lens_view_type\" : \"tabular\",\n            \"lens_display_type\" : \"table\",\n            \"locked\" : false,\n            \"blob_mime_type\" : null,\n            \"hide_from_data_json\" : false,\n            \"publication_date\" : \"2017-05-17T16:26:45.000Z\"\n          },\n        \"classification\" :\n          {\n            \"categories\" : [],\n            \"tags\" : [],\n            \"domain_category\" : \"Transportation\",\n            \"domain_tags\" :\n              [ \"chicago transit authority\", \"cta\", \"public transit\" ],\n            \"domain_metadata\" :\n              [\n                {\n                  \"key\" : \"Metadata_Data-Owner\",\n                  \"value\" : \"Chicago Transit Authority \"\n                }\n              ]\n          },\n        \"metadata\" : { \"domain\" : \"data.cityofchicago.org\" },\n        \"permalink\" : \"https://data.cityofchicago.org/d/pnau-cf66\",\n        \"link\" : \"https://data.cityofchicago.org/Transportation/CTA-List-of-CTA-Datasets/pnau-cf66\",\n        \"owner\" :\n          {\n            \"id\" : \"6bsn-5494\",\n            \"user_type\" : \"interactive\",\n            \"display_name\" : \"CTA\"\n          },\n        \"creator\" :\n          {\n            \"id\" : \"6bsn-5494\",\n            \"user_type\" : \"interactive\",\n            \"display_name\" : \"CTA\"\n          }\n      },\n      {\n        \"resource\" :\n          {\n            \"name\" : \"CTA - Ridership - 'L' Station Entries - Daily Totals\",\n            \"id\" : \"5neh-572f\",\n            \"resource_name\" : null,\n            \"parent_fxf\" : [],\n            \"description\" : \"This list shows daily totals of ridership, by station entry, for each 'L' station dating back to 2001. Dataset shows entries at all turnstiles, combined, for each station. Daytypes are as follows: W=Weekday, A=Saturday, U=Sunday/Holiday. See attached readme file for information on how these numbers are calculated.\",\n            \"attribution\" : \"Chicago Transit Authority\",\n            \"attribution_link\" : \"http://www.transitchicago.com\",\n            \"contact_email\" : null,\n            \"type\" : \"dataset\",\n            \"updatedAt\" : \"2025-06-30T18:42:45.000Z\",\n            \"createdAt\" : \"2011-08-05T19:53:18.000Z\",\n            \"metadata_updated_at\" : \"2025-06-30T18:42:43.000Z\",\n            \"data_updated_at\" : \"2025-06-30T18:42:45.000Z\",\n            \"page_views\" :\n              {\n                \"page_views_last_week\" : 64,\n                \"page_views_last_month\" : 304,\n                \"page_views_total\" : 49426,\n                \"page_views_last_week_log\" : 6.022367813028454,\n                \"page_views_last_month_log\" : 8.252665432450248,\n                \"page_views_total_log\" : 15.593011723484796\n              },\n            \"columns_name\" :\n              [ \"rides\", \"stationname\", \"station_id\", \"daytype\", \"date\" ],\n            \"columns_field_name\" :\n              [ \"rides\", \"stationname\", \"station_id\", \"daytype\", \"date\" ],\n            \"columns_datatype\" :\n              [ \"Number\", \"Text\", \"Number\", \"Text\", \"Calendar date\" ],\n            \"columns_description\" : [ \"\", \"\", \"\", \"\", \"\" ],\n            \"columns_format\" :\n              [\n                {},\n                {},\n                {\n                  \"precisionStyle\" : \"standard\",\n                  \"noCommas\" : \"true\",\n                  \"align\" : \"right\",\n                  \"aggregate\" : \"count\"\n                },\n                {},\n                { \"view\" : \"date\", \"align\" : \"left\" }\n              ],\n            \"download_count\" : 27162,\n            \"provenance\" : \"official\",\n            \"lens_view_type\" : \"tabular\",\n            \"lens_display_type\" : \"table\",\n            \"locked\" : false,\n            \"blob_mime_type\" : null,\n            \"hide_from_data_json\" : false,\n            \"publication_date\" : \"2018-05-18T22:41:47.000Z\"\n          },\n        \"classification\" :\n          {\n            \"categories\" : [],\n            \"tags\" : [],\n            \"domain_category\" : \"Transportation\",\n            \"domain_tags\" :\n              [\n                \"chicago transit authority\",\n                \"cta\",\n                \"public transit\",\n                \"ridership\"\n              ],\n            \"domain_metadata\" :\n              [\n                {\n                  \"key\" : \"Metadata_Data-Owner\",\n                  \"value\" : \"Chicago Transit Authority \"\n                }\n              ]\n          },\n        \"metadata\" : { \"domain\" : \"data.cityofchicago.org\" },\n        \"permalink\" : \"https://data.cityofchicago.org/d/5neh-572f\",\n        \"link\" : \"https://data.cityofchicago.org/Transportation/CTA-Ridership-L-Station-Entries-Daily-Totals/5neh-572f\",\n        \"owner\" :\n          {\n            \"id\" : \"6bsn-5494\",\n            \"user_type\" : \"interactive\",\n            \"display_name\" : \"CTA\"\n          },\n        \"creator\" :\n          {\n            \"id\" : \"6bsn-5494\",\n            \"user_type\" : \"interactive\",\n            \"display_name\" : \"CTA\"\n          }\n      },\n      {\n        \"resource\" :\n          {\n            \"name\" : \"CTA - Ridership - 'L' Station Entries - Monthly Day-Type Averages & Totals\",\n            \"id\" : \"t2rn-p8d7\",\n            \"resource_name\" : null,\n            \"parent_fxf\" : [],\n            \"description\" : \"This dataset lists monthly station entry averages, by day type (Weekday, Saturday or Sunday/Holiday), as well as monthly totals, beginning in 2001. Note that some stations (such as on the Cermak Branch--now Pink Line) and Skokie did not have Saturday and/or Sunday/holiday service until more recent years, although, in cases where weekday service ran past midnight, late evening fares may appear as part of Saturday tallies.\",\n            \"attribution\" : \"Chicago Transit Authority\",\n            \"attribution_link\" : \"http://www.transitchicago.com\",\n            \"contact_email\" : null,\n            \"type\" : \"dataset\",\n            \"updatedAt\" : \"2025-06-30T18:43:45.000Z\",\n            \"createdAt\" : \"2011-08-05T19:32:43.000Z\",\n            \"metadata_updated_at\" : \"2025-06-30T18:43:44.000Z\",\n            \"data_updated_at\" : \"2025-06-30T18:43:45.000Z\",\n            \"page_views\" :\n              {\n                \"page_views_last_week\" : 94,\n                \"page_views_last_month\" : 322,\n                \"page_views_total\" : 23107,\n                \"page_views_last_week_log\" : 6.569855608330948,\n                \"page_views_last_month_log\" : 8.335390354693924,\n                \"page_views_total_log\" : 14.496104779340127\n              },\n            \"columns_name\" :\n              [\n                \"monthtotal\",\n                \"stationame\",\n                \"station_id\",\n                \"avg_sunday-holiday_rides\",\n                \"month_beginning\",\n                \"avg_saturday_rides\",\n                \"avg_weekday_rides\"\n              ],\n            \"columns_field_name\" :\n              [\n                \"monthtotal\",\n                \"stationame\",\n                \"station_id\",\n                \"avg_sunday_holiday_rides\",\n                \"month_beginning\",\n                \"avg_saturday_rides\",\n                \"avg_weekday_rides\"\n              ],\n            \"columns_datatype\" :\n              [\n                \"Number\",\n                \"Text\",\n                \"Number\",\n                \"Number\",\n                \"Calendar date\",\n                \"Number\",\n                \"Number\"\n              ],\n            \"columns_description\" : [ \"\", \"\", \"\", \"\", \"\", \"\", \"\" ],\n            \"columns_format\" :\n              [\n                {},\n                {},\n                {\n                  \"precisionStyle\" : \"standard\",\n                  \"noCommas\" : \"true\",\n                  \"align\" : \"right\",\n                  \"aggregate\" : \"count\"\n                },\n                {},\n                { \"view\" : \"date\", \"align\" : \"left\" },\n                {},\n                {}\n              ],\n            \"download_count\" : 6253,\n            \"provenance\" : \"official\",\n            \"lens_view_type\" : \"tabular\",\n            \"lens_display_type\" : \"table\",\n            \"locked\" : false,\n            \"blob_mime_type\" : null,\n            \"hide_from_data_json\" : false,\n            \"publication_date\" : \"2018-05-18T22:41:47.000Z\"\n          },\n        \"classification\" :\n          {\n            \"categories\" : [ \"finance\", \"transportation\", \"infrastructure\" ],\n            \"tags\" : [],\n            \"domain_category\" : \"Transportation\",\n            \"domain_tags\" : [ \"cta\", \"public transit\", \"ridership\" ],\n            \"domain_metadata\" :\n              [\n                { \"key\" : \"Metadata_Frequency\", \"value\" : \"\" },\n                {\n                  \"key\" : \"Metadata_Data-Owner\",\n                  \"value\" : \"Chicago Transit Authority \"\n                },\n                { \"key\" : \"Metadata_Time-Period\", \"value\" : \"\" }\n              ]\n          },\n        \"metadata\" : { \"domain\" : \"data.cityofchicago.org\" },\n        \"permalink\" : \"https://data.cityofchicago.org/d/t2rn-p8d7\",\n        \"link\" : \"https://data.cityofchicago.org/Transportation/CTA-Ridership-L-Station-Entries-Monthly-Day-Type-A/t2rn-p8d7\",\n        \"owner\" :\n          {\n            \"id\" : \"6bsn-5494\",\n            \"user_type\" : \"interactive\",\n            \"display_name\" : \"CTA\"\n          },\n        \"creator\" :\n          {\n            \"id\" : \"6bsn-5494\",\n            \"user_type\" : \"interactive\",\n            \"display_name\" : \"CTA\"\n          }\n      },\n      {\n        \"resource\" :\n          {\n            \"name\" : \"CTA - System Information - List of 'L' Stops\",\n            \"id\" : \"8pix-ypme\",\n            \"resource_name\" : null,\n            \"parent_fxf\" : [],\n            \"description\" : \"This list of 'L' stops provides location and basic service availability information for each place on the CTA system where a train stops, along with formal station names and stop descriptions.\",\n            \"attribution\" : \"Chicago Transit Authority\",\n            \"attribution_link\" : \"http://www.transitchicago.com\",\n            \"contact_email\" : null,\n            \"type\" : \"dataset\",\n            \"updatedAt\" : \"2025-07-20T00:40:19.000Z\",\n            \"createdAt\" : \"2011-08-04T19:53:20.000Z\",\n            \"metadata_updated_at\" : \"2025-07-20T00:40:18.000Z\",\n            \"data_updated_at\" : \"2025-07-20T00:40:19.000Z\",\n            \"page_views\" :\n              {\n                \"page_views_last_week\" : 116,\n                \"page_views_last_month\" : 338,\n                \"page_views_total\" : 27414,\n                \"page_views_last_week_log\" : 6.870364719583405,\n                \"page_views_last_month_log\" : 8.405141463136344,\n                \"page_views_total_log\" : 14.742677853184164\n              },\n            \"columns_name\" :\n              [\n                \"STOP_ID\",\n                \"Y\",\n                \"DIRECTION_ID\",\n                \"STOP_NAME\",\n                \"BLUE\",\n                \"STATION_NAME\",\n                \"STATION_DESCRIPTIVE_NAME\",\n                \"Location (zip)\",\n                \"Historical Wards 2003-2015\",\n                \"Location\",\n                \"Location (address)\",\n                \"MAP_ID\",\n                \"Zip Codes\",\n                \"Community Areas\",\n                \"Wards\",\n                \"O\",\n                \"RED\",\n                \"Pexp\",\n                \"G\",\n                \"Census Tracts\",\n                \"ADA\",\n                \"P\",\n                \"Pnk\",\n                \"BRN\",\n                \"Location (city)\",\n                \"Location (state)\"\n              ],\n            \"columns_field_name\" :\n              [\n                \"stop_id\",\n                \"y\",\n                \"direction_id\",\n                \"stop_name\",\n                \"blue\",\n                \"station_name\",\n                \"station_descriptive_name\",\n                \"location_zip\",\n                \":@computed_region_awaf_s7ux\",\n                \"location\",\n                \"location_address\",\n                \"map_id\",\n                \":@computed_region_6mkv_f3dw\",\n                \":@computed_region_vrxf_vc4k\",\n                \":@computed_region_43wa_7qmu\",\n                \"o\",\n                \"red\",\n                \"pexp\",\n                \"g\",\n                \":@computed_region_bdys_3d7i\",\n                \"ada\",\n                \"p\",\n                \"pnk\",\n                \"brn\",\n                \"location_city\",\n                \"location_state\"\n              ],\n            \"columns_datatype\" :\n              [\n                \"Number\",\n                \"Checkbox\",\n                \"Text\",\n                \"Text\",\n                \"Checkbox\",\n                \"Text\",\n                \"Text\",\n                \"Text\",\n                \"Number\",\n                \"Point\",\n                \"Text\",\n                \"Number\",\n                \"Number\",\n                \"Number\",\n                \"Number\",\n                \"Checkbox\",\n                \"Checkbox\",\n                \"Checkbox\",\n                \"Checkbox\",\n                \"Number\",\n                \"Checkbox\",\n                \"Checkbox\",\n                \"Checkbox\",\n                \"Checkbox\",\n                \"Text\",\n                \"Text\"\n              ],\n            \"columns_description\" :\n              [\n                \"\",\n                \"\",\n                \"Normal direction of train traffic at platform.\",\n                \"\",\n                \"\",\n                \"\",\n                \"A more fully descriptive name of a station.\",\n                \"\",\n                \"\",\n                \"\",\n                \"\",\n                \"\",\n                \"\",\n                \"\",\n                \"\",\n                \"\",\n                \"\",\n                \"\",\n                \"\",\n                \"\",\n                \"\",\n                \"\",\n                \"\",\n                \"\",\n                \"\",\n                \"\"\n              ],\n            \"columns_format\" :\n              [\n                {\n                  \"precisionStyle\" : \"standard\",\n                  \"noCommas\" : \"true\",\n                  \"align\" : \"right\",\n                  \"aggregate\" : \"count\"\n                },\n                {},\n                {},\n                {},\n                {},\n                {},\n                {},\n                {},\n                {},\n                {},\n                {},\n                {\n                  \"precisionStyle\" : \"standard\",\n                  \"noCommas\" : \"true\",\n                  \"align\" : \"right\"\n                },\n                {},\n                {},\n                {},\n                {},\n                {},\n                {},\n                {},\n                {},\n                {},\n                {},\n                {},\n                {},\n                {},\n                {}\n              ],\n            \"download_count\" : 929426,\n            \"provenance\" : \"official\",\n            \"lens_view_type\" : \"tabular\",\n            \"lens_display_type\" : \"table\",\n            \"locked\" : false,\n            \"blob_mime_type\" : null,\n            \"hide_from_data_json\" : false,\n            \"publication_date\" : \"2018-05-15T18:24:32.000Z\"\n          },\n        \"classification\" :\n          {\n            \"categories\" : [],\n            \"tags\" : [],\n            \"domain_category\" : \"Transportation\",\n            \"domain_tags\" :\n              [\n                \"cta\",\n                \"public transit\",\n                \"rail\",\n                \"stations\",\n                \"sustainability\"\n              ],\n            \"domain_metadata\" :\n              [\n                { \"key\" : \"Metadata_Frequency\", \"value\" : \"\" },\n                {\n                  \"key\" : \"Metadata_Data-Owner\",\n                  \"value\" : \"Chicago Transit Authority \"\n                },\n                { \"key\" : \"Metadata_Time-Period\", \"value\" : \"\" },\n                {\n                  \"key\" : \"Metadata_Last-Updated-Date-via-Automated-Load\",\n                  \"value\" : \"\"\n                }\n              ]\n          },\n        \"metadata\" : { \"domain\" : \"data.cityofchicago.org\" },\n        \"permalink\" : \"https://data.cityofchicago.org/d/8pix-ypme\",\n        \"link\" : \"https://data.cityofchicago.org/Transportation/CTA-System-Information-List-of-L-Stops/8pix-ypme\",\n        \"owner\" :\n          {\n            \"id\" : \"6bsn-5494\",\n            \"user_type\" : \"interactive\",\n            \"display_name\" : \"CTA\"\n          },\n        \"creator\" :\n          {\n            \"id\" : \"6bsn-5494\",\n            \"user_type\" : \"interactive\",\n            \"display_name\" : \"CTA\"\n          }\n      },\n      {\n        \"resource\" :\n          {\n            \"name\" : \"CTA - Ridership - Annual Boarding Totals\",\n            \"id\" : \"w8km-9pzd\",\n            \"resource_name\" : null,\n            \"parent_fxf\" : [],\n            \"description\" : \"This dataset gives annual ridership totals dating to the mid-1980s. Numbers are presented in boardings (see attached readme file for information on how these numbers are calculated).\",\n            \"attribution\" : \"Chicago Transit Authority\",\n            \"attribution_link\" : \"http://www.transitchicago.com\",\n            \"contact_email\" : null,\n            \"type\" : \"dataset\",\n            \"updatedAt\" : \"2019-08-21T16:00:05.000Z\",\n            \"createdAt\" : \"2011-08-11T21:15:40.000Z\",\n            \"metadata_updated_at\" : \"2019-08-21T16:00:03.000Z\",\n            \"data_updated_at\" : \"2019-08-21T16:00:05.000Z\",\n            \"page_views\" :\n              {\n                \"page_views_last_week\" : 27,\n                \"page_views_last_month\" : 121,\n                \"page_views_total\" : 19991,\n                \"page_views_last_week_log\" : 4.807354922057604,\n                \"page_views_last_month_log\" : 6.930737337562887,\n                \"page_views_total_log\" : 14.287135186086703\n              },\n            \"columns_name\" : [ \"year\", \"bus\", \"total\", \"paratransit\", \"rail\" ],\n            \"columns_field_name\" :\n              [ \"year\", \"bus\", \"total\", \"paratransit\", \"rail\" ],\n            \"columns_datatype\" :\n              [ \"Number\", \"Number\", \"Number\", \"Number\", \"Number\" ],\n            \"columns_description\" : [ \"\", \"\", \"\", \"\", \"\" ],\n            \"columns_format\" :\n              [\n                {\n                  \"precisionStyle\" : \"standard\",\n                  \"noCommas\" : \"true\",\n                  \"align\" : \"right\",\n                  \"aggregate\" : \"count\"\n                },\n                {},\n                {},\n                {},\n                {}\n              ],\n            \"download_count\" : 9235,\n            \"provenance\" : \"official\",\n            \"lens_view_type\" : \"tabular\",\n            \"lens_display_type\" : \"table\",\n            \"locked\" : false,\n            \"blob_mime_type\" : null,\n            \"hide_from_data_json\" : false,\n            \"publication_date\" : \"2018-06-12T16:57:25.000Z\"\n          },\n        \"classification\" :\n          {\n            \"categories\" : [],\n            \"tags\" : [],\n            \"domain_category\" : \"Transportation\",\n            \"domain_tags\" :\n              [ \"cta\", \"public transit\", \"ridership\", \"sustainability\" ],\n            \"domain_metadata\" :\n              [\n                { \"key\" : \"Metadata_Frequency\", \"value\" : \"\" },\n                {\n                  \"key\" : \"Metadata_Data-Owner\",\n                  \"value\" : \"Chicago Transit Authority \"\n                },\n                { \"key\" : \"Metadata_Time-Period\", \"value\" : \"\" },\n                {\n                  \"key\" : \"Metadata_Last-Updated-Date-via-Automated-Load\",\n                  \"value\" : \"\"\n                }\n              ]\n          },\n        \"metadata\" : { \"domain\" : \"data.cityofchicago.org\" },\n        \"permalink\" : \"https://data.cityofchicago.org/d/w8km-9pzd\",\n        \"link\" : \"https://data.cityofchicago.org/Transportation/CTA-Ridership-Annual-Boarding-Totals/w8km-9pzd\",\n        \"owner\" :\n          {\n            \"id\" : \"6bsn-5494\",\n            \"user_type\" : \"interactive\",\n            \"display_name\" : \"CTA\"\n          },\n        \"creator\" :\n          {\n            \"id\" : \"6bsn-5494\",\n            \"user_type\" : \"interactive\",\n            \"display_name\" : \"CTA\"\n          }\n      },\n      {\n        \"resource\" :\n          {\n            \"name\" : \"CTA - Ridership - Bus Routes - Monthly Day-Type Averages & Totals\",\n            \"id\" : \"bynn-gwxy\",\n            \"resource_name\" : null,\n            \"parent_fxf\" : [],\n            \"description\" : \"This dataset shows monthly averages, by day type (weekday, Saturday or Sunday/Holiday) and monthly totals for all CTA bus routes, back to 2001. See attached readme file for information on how these numbers are calculated.\",\n            \"attribution\" : \"Chicago Transit Authority\",\n            \"attribution_link\" : \"http://www.transitchicago.com\",\n            \"contact_email\" : null,\n            \"type\" : \"dataset\",\n            \"updatedAt\" : \"2025-06-30T18:41:53.000Z\",\n            \"createdAt\" : \"2011-08-05T19:25:49.000Z\",\n            \"metadata_updated_at\" : \"2025-06-30T18:41:52.000Z\",\n            \"data_updated_at\" : \"2025-06-30T18:41:53.000Z\",\n            \"page_views\" :\n              {\n                \"page_views_last_week\" : 51,\n                \"page_views_last_month\" : 548,\n                \"page_views_total\" : 14965,\n                \"page_views_last_week_log\" : 5.700439718141093,\n                \"page_views_last_month_log\" : 9.100662339005199,\n                \"page_views_total_log\" : 13.869401059778095\n              },\n            \"columns_name\" :\n              [\n                \"route\",\n                \"Avg_Saturday_Rides\",\n                \"routename\",\n                \"Month_Beginning\",\n                \"Avg_Weekday_Rides\",\n                \"Avg_Sunday-Holiday_Rides\",\n                \"MonthTotal\"\n              ],\n            \"columns_field_name\" :\n              [\n                \"route\",\n                \"avg_saturday_rides\",\n                \"routename\",\n                \"month_beginning\",\n                \"avg_weekday_rides\",\n                \"avg_sunday_holiday_rides\",\n                \"monthtotal\"\n              ],\n            \"columns_datatype\" :\n              [\n                \"Text\",\n                \"Number\",\n                \"Text\",\n                \"Calendar date\",\n                \"Number\",\n                \"Number\",\n                \"Number\"\n              ],\n            \"columns_description\" : [ \"\", \"\", \"\", \"\", \"\", \"\", \"\" ],\n            \"columns_format\" :\n              [\n                { \"align\" : \"left\", \"aggregate\" : \"count\" },\n                {\n                  \"precisionStyle\" : \"standard\",\n                  \"noCommas\" : \"false\",\n                  \"align\" : \"left\"\n                },\n                {},\n                { \"view\" : \"date\", \"align\" : \"left\" },\n                {\n                  \"precisionStyle\" : \"standard\",\n                  \"noCommas\" : \"false\",\n                  \"align\" : \"left\"\n                },\n                {\n                  \"precisionStyle\" : \"standard\",\n                  \"noCommas\" : \"false\",\n                  \"align\" : \"left\"\n                },\n                {\n                  \"precisionStyle\" : \"standard\",\n                  \"noCommas\" : \"false\",\n                  \"align\" : \"left\"\n                }\n              ],\n            \"download_count\" : 5766,\n            \"provenance\" : \"official\",\n            \"lens_view_type\" : \"tabular\",\n            \"lens_display_type\" : \"table\",\n            \"locked\" : false,\n            \"blob_mime_type\" : null,\n            \"hide_from_data_json\" : false,\n            \"publication_date\" : \"2018-05-18T22:41:26.000Z\"\n          },\n        \"classification\" :\n          {\n            \"categories\" : [ \"transportation\", \"finance\", \"infrastructure\" ],\n            \"tags\" : [],\n            \"domain_category\" : \"Transportation\",\n            \"domain_tags\" :\n              [ \"cta\", \"public transit\", \"ridership\", \"sustainability\" ],\n            \"domain_metadata\" :\n              [\n                { \"key\" : \"Metadata_Frequency\", \"value\" : \"\" },\n                {\n                  \"key\" : \"Metadata_Data-Owner\",\n                  \"value\" : \"Chicago Transit Authority \"\n                },\n                { \"key\" : \"Metadata_Time-Period\", \"value\" : \"\" },\n                {\n                  \"key\" : \"Metadata_Last-Updated-Date-via-Automated-Load\",\n                  \"value\" : \"\"\n                }\n              ]\n          },\n        \"metadata\" : { \"domain\" : \"data.cityofchicago.org\" },\n        \"permalink\" : \"https://data.cityofchicago.org/d/bynn-gwxy\",\n        \"link\" : \"https://data.cityofchicago.org/Transportation/CTA-Ridership-Bus-Routes-Monthly-Day-Type-Averages/bynn-gwxy\",\n        \"owner\" :\n          {\n            \"id\" : \"6bsn-5494\",\n            \"user_type\" : \"interactive\",\n            \"display_name\" : \"CTA\"\n          },\n        \"creator\" :\n          {\n            \"id\" : \"6bsn-5494\",\n            \"user_type\" : \"interactive\",\n            \"display_name\" : \"CTA\"\n          }\n      },\n      {\n        \"resource\" :\n          {\n            \"name\" : \"CTA - Ridership - Bus Routes - Daily Totals by Route\",\n            \"id\" : \"jyb9-n7fm\",\n            \"resource_name\" : null,\n            \"parent_fxf\" : [],\n            \"description\" : \"This dataset shows total daily ridership on a per-route basis dating back to 2001. Daytypes are as follows: W=Weekday, A=Saturday, U=Sunday/Holiday. See attached readme file for more detailed information.\",\n            \"attribution\" : \"Chicago Transit Authority\",\n            \"attribution_link\" : \"http://www.transitchicago.com\",\n            \"contact_email\" : null,\n            \"type\" : \"dataset\",\n            \"updatedAt\" : \"2025-06-30T18:41:06.000Z\",\n            \"createdAt\" : \"2011-08-05T19:35:20.000Z\",\n            \"metadata_updated_at\" : \"2025-06-30T18:41:05.000Z\",\n            \"data_updated_at\" : \"2025-06-30T18:41:06.000Z\",\n            \"page_views\" :\n              {\n                \"page_views_last_week\" : 51,\n                \"page_views_last_month\" : 195,\n                \"page_views_total\" : 29156,\n                \"page_views_last_week_log\" : 5.700439718141093,\n                \"page_views_last_month_log\" : 7.6147098441152075,\n                \"page_views_total_log\" : 14.831554666162994\n              },\n            \"columns_name\" : [ \"date\", \"rides\", \"daytype\", \"route\" ],\n            \"columns_field_name\" : [ \"date\", \"rides\", \"daytype\", \"route\" ],\n            \"columns_datatype\" : [ \"Calendar date\", \"Number\", \"Text\", \"Text\" ],\n            \"columns_description\" :\n              [\n                \"\",\n                \"\",\n                \"Indicates whether the day was a weekday, saturday, or sunday/holiday.\",\n                \"\"\n              ],\n            \"columns_format\" :\n              [\n                { \"view\" : \"date\", \"align\" : \"left\" },\n                {},\n                { \"align\" : \"left\" },\n                { \"align\" : \"left\", \"aggregate\" : \"count\" }\n              ],\n            \"download_count\" : 7435,\n            \"provenance\" : \"official\",\n            \"lens_view_type\" : \"tabular\",\n            \"lens_display_type\" : \"table\",\n            \"locked\" : false,\n            \"blob_mime_type\" : null,\n            \"hide_from_data_json\" : false,\n            \"publication_date\" : \"2018-05-18T22:41:24.000Z\"\n          },\n        \"classification\" :\n          {\n            \"categories\" : [],\n            \"tags\" : [],\n            \"domain_category\" : \"Transportation\",\n            \"domain_tags\" :\n              [\n                \"chicago transit authority\",\n                \"cta\",\n                \"public transit\",\n                \"ridership\",\n                \"sustainability\"\n              ],\n            \"domain_metadata\" :\n              [\n                {\n                  \"key\" : \"Metadata_Data-Owner\",\n                  \"value\" : \"Chicago Transit Authority \"\n                }\n              ]\n          },\n        \"metadata\" : { \"domain\" : \"data.cityofchicago.org\" },\n        \"permalink\" : \"https://data.cityofchicago.org/d/jyb9-n7fm\",\n        \"link\" : \"https://data.cityofchicago.org/Transportation/CTA-Ridership-Bus-Routes-Daily-Totals-by-Route/jyb9-n7fm\",\n        \"owner\" :\n          {\n            \"id\" : \"6bsn-5494\",\n            \"user_type\" : \"interactive\",\n            \"display_name\" : \"CTA\"\n          },\n        \"creator\" :\n          {\n            \"id\" : \"6bsn-5494\",\n            \"user_type\" : \"interactive\",\n            \"display_name\" : \"CTA\"\n          }\n      },\n      {\n        \"resource\" :\n          {\n            \"name\" : \"CTA - Ridership - Avg. Weekday Bus Stop Boardings in October 2012\",\n            \"id\" : \"mq3i-nnqe\",\n            \"resource_name\" : null,\n            \"parent_fxf\" : [],\n            \"description\" : \"This dataset shows approximate, average, weekday boardings by bus stop from the month of October 2012.\",\n            \"attribution\" : \"Chicago Transit Authority\",\n            \"attribution_link\" : \"http://www.transitchicago.com\",\n            \"contact_email\" : null,\n            \"type\" : \"dataset\",\n            \"updatedAt\" : \"2016-07-11T17:19:29.000Z\",\n            \"createdAt\" : \"2011-08-11T21:22:31.000Z\",\n            \"metadata_updated_at\" : \"2016-07-11T17:19:29.000Z\",\n            \"data_updated_at\" : \"2012-12-20T16:18:49.000Z\",\n            \"page_views\" :\n              {\n                \"page_views_last_week\" : 20,\n                \"page_views_last_month\" : 101,\n                \"page_views_total\" : 18333,\n                \"page_views_last_week_log\" : 4.392317422778761,\n                \"page_views_last_month_log\" : 6.672425341971495,\n                \"page_views_total_log\" : 14.162233958149617\n              },\n            \"columns_name\" :\n              [\n                \"month_beginning\",\n                \"cross_street\",\n                \"boardings\",\n                \"stop_id\",\n                \"alightings\",\n                \"Community Areas\",\n                \"location\",\n                \"daytype\",\n                \"routes\",\n                \"Wards\",\n                \"on_street\",\n                \"Historical Wards 2003-2015\",\n                \"location (state)\",\n                \"location (zip)\",\n                \"location (address)\",\n                \"Zip Codes\",\n                \"Census Tracts\",\n                \"location (city)\"\n              ],\n            \"columns_field_name\" :\n              [\n                \"month\",\n                \"cross_street\",\n                \"boardings\",\n                \"stop_id\",\n                \"alightings\",\n                \":@computed_region_vrxf_vc4k\",\n                \"location\",\n                \"daytype\",\n                \"routes\",\n                \":@computed_region_43wa_7qmu\",\n                \"on_street\",\n                \":@computed_region_awaf_s7ux\",\n                \"location_state\",\n                \"location_zip\",\n                \"location_address\",\n                \":@computed_region_6mkv_f3dw\",\n                \":@computed_region_bdys_3d7i\",\n                \"location_city\"\n              ],\n            \"columns_datatype\" :\n              [\n                \"Calendar date\",\n                \"Text\",\n                \"Number\",\n                \"Number\",\n                \"Number\",\n                \"Number\",\n                \"Point\",\n                \"Text\",\n                \"Text\",\n                \"Number\",\n                \"Text\",\n                \"Number\",\n                \"Text\",\n                \"Text\",\n                \"Text\",\n                \"Number\",\n                \"Number\",\n                \"Text\"\n              ],\n            \"columns_description\" :\n              [\n                \"\",\n                \"\",\n                \"\",\n                \"\",\n                \"\",\n                \"\",\n                \"\",\n                \"\",\n                \"\",\n                \"\",\n                \"\",\n                \"\",\n                \"\",\n                \"\",\n                \"\",\n                \"\",\n                \"\",\n                \"\"\n              ],\n            \"columns_format\" :\n              [\n                { \"view\" : \"date\", \"align\" : \"left\" },\n                {},\n                {},\n                {\n                  \"precisionStyle\" : \"standard\",\n                  \"noCommas\" : \"true\",\n                  \"align\" : \"right\",\n                  \"aggregate\" : \"count\"\n                },\n                {},\n                {},\n                {},\n                {},\n                {},\n                {},\n                {},\n                {},\n                {},\n                {},\n                {},\n                {},\n                {},\n                {}\n              ],\n            \"download_count\" : 10779,\n            \"provenance\" : \"official\",\n            \"lens_view_type\" : \"tabular\",\n            \"lens_display_type\" : \"table\",\n            \"locked\" : false,\n            \"blob_mime_type\" : null,\n            \"hide_from_data_json\" : false,\n            \"publication_date\" : \"2012-12-20T16:25:40.000Z\"\n          },\n        \"classification\" :\n          {\n            \"categories\" : [ \"transportation\" ],\n            \"tags\" : [],\n            \"domain_category\" : \"Transportation\",\n            \"domain_tags\" :\n              [\n                \"chicago transit authority\",\n                \"cta\",\n                \"public transit\",\n                \"ridership\",\n                \"sustainability\"\n              ],\n            \"domain_metadata\" :\n              [\n                {\n                  \"key\" : \"Metadata_Data-Owner\",\n                  \"value\" : \"Chicago Transit Authority \"\n                }\n              ]\n          },\n        \"metadata\" : { \"domain\" : \"data.cityofchicago.org\" },\n        \"permalink\" : \"https://data.cityofchicago.org/d/mq3i-nnqe\",\n        \"link\" : \"https://data.cityofchicago.org/Transportation/CTA-Ridership-Avg-Weekday-Bus-Stop-Boardings-in-Oc/mq3i-nnqe\",\n        \"owner\" :\n          {\n            \"id\" : \"6bsn-5494\",\n            \"user_type\" : \"interactive\",\n            \"display_name\" : \"CTA\"\n          },\n        \"creator\" :\n          {\n            \"id\" : \"6bsn-5494\",\n            \"user_type\" : \"interactive\",\n            \"display_name\" : \"CTA\"\n          }\n      },\n      {\n        \"resource\" :\n          {\n            \"name\" : \"CTA - Bus Routes\",\n            \"id\" : \"6uva-a5ei\",\n            \"resource_name\" : null,\n            \"parent_fxf\" : [],\n            \"description\" : \"Lines representing CTA bus routes.\\n\\nThis dataset is in a format for spatial datasets that is inherently tabular but allows for a map as a derived view. Please click the indicated link below for such a map.\\n\\nTo export the data in either tabular or geographic format, please use the Export button on this dataset.\",\n            \"attribution\" : \"City of Chicago\",\n            \"attribution_link\" : \"http://www.transitchicago.com/\",\n            \"contact_email\" : null,\n            \"type\" : \"dataset\",\n            \"updatedAt\" : \"2025-01-08T17:26:16.000Z\",\n            \"createdAt\" : \"2024-07-31T16:59:40.000Z\",\n            \"metadata_updated_at\" : \"2025-01-08T17:26:15.000Z\",\n            \"data_updated_at\" : \"2025-01-08T17:26:16.000Z\",\n            \"page_views\" :\n              {\n                \"page_views_last_week\" : 52,\n                \"page_views_last_month\" : 158,\n                \"page_views_total\" : 1464,\n                \"page_views_last_week_log\" : 5.7279204545632,\n                \"page_views_last_month_log\" : 7.312882955284356,\n                \"page_views_total_log\" : 10.51668494930961\n              },\n            \"columns_name\" :\n              [ \"SUN\", \"the_geom\", \"ROUTE\", \"NAME\", \"WKDAY\", \"SAT\" ],\n            \"columns_field_name\" :\n              [ \"sun\", \"the_geom\", \"route\", \"name\", \"wkday\", \"sat\" ],\n            \"columns_datatype\" :\n              [\n                \"Checkbox\",\n                \"MultiLine\",\n                \"Text\",\n                \"Text\",\n                \"Checkbox\",\n                \"Checkbox\"\n              ],\n            \"columns_description\" :\n              [\n                \"Does the route run on Sunday?\",\n                \"\",\n                \"Route Number\",\n                \"Route Name\",\n                \"Does the route run on weekdays?\",\n                \"Does the route run on Saturday?\"\n              ],\n            \"columns_format\" :\n              [\n                { \"displayStyle\" : \"yesno\" },\n                {},\n                {},\n                {},\n                { \"displayStyle\" : \"yesno\" },\n                { \"displayStyle\" : \"yesno\" }\n              ],\n            \"download_count\" : 519,\n            \"provenance\" : \"official\",\n            \"lens_view_type\" : \"tabular\",\n            \"lens_display_type\" : \"table\",\n            \"locked\" : false,\n            \"blob_mime_type\" : null,\n            \"hide_from_data_json\" : false,\n            \"publication_date\" : \"2024-07-31T17:15:34.000Z\"\n          },\n        \"classification\" :\n          {\n            \"categories\" : [],\n            \"tags\" : [],\n            \"domain_category\" : \"Transportation\",\n            \"domain_tags\" :\n              [\n                \"bus\",\n                \"cta\",\n                \"geo_layer\",\n                \"public transit\",\n                \"sustainability\",\n                \"transportation\"\n              ],\n            \"domain_metadata\" :\n              [\n                {\n                  \"key\" : \"Metadata_Data-Owner\",\n                  \"value\" : \"Chicago Transit Authority\"\n                },\n                { \"key\" : \"Metadata_Time-Period\", \"value\" : \"March 2024\" }\n              ]\n          },\n        \"metadata\" :\n          {\n            \"domain\" : \"data.cityofchicago.org\",\n            \"license\" : \"See Terms of Use\"\n          },\n        \"permalink\" : \"https://data.cityofchicago.org/d/6uva-a5ei\",\n        \"link\" : \"https://data.cityofchicago.org/Transportation/CTA-Bus-Routes/6uva-a5ei\",\n        \"owner\" :\n          {\n            \"id\" : \"vewm-vupz\",\n            \"user_type\" : \"interactive\",\n            \"display_name\" : \"Jonathan Levy\"\n          },\n        \"creator\" :\n          {\n            \"id\" : \"vewm-vupz\",\n            \"user_type\" : \"interactive\",\n            \"display_name\" : \"Jonathan Levy\"\n          }\n      }\n    ],\n  \"resultSetSize\" : 20,\n  \"timings\" : { \"serviceMillis\" : 19, \"searchMillis\" : [ 6, 5 ] },\n  \"warnings\" : []\n}"), 
    timing = c(redirect = 0, namelookup = 1e-05, connect = 0, 
    pretransfer = 5.9e-05, starttransfer = 0.062824, total = 0.062979
    ), cache = new.env(parent = emptyenv())), class = "httr2_response")
