% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/apply_template.R
\name{apply_template}
\alias{apply_template}
\alias{apply_template.data.frame}
\alias{apply_template.softermax.plate}
\title{Annotate Plate Read Data with Metadata from a Template}
\usage{
apply_template(plate, template, ...)

\method{apply_template}{data.frame}(plate, template, ...)

\method{apply_template}{softermax.plate}(plate, template, ...)
}
\arguments{
\item{plate}{Either a \code{softermax.plate} object (produced by
\code{\link{read_softmax_xml}}), or a data frame.}

\item{template}{A data frame containing information about wells in a plate.
See \code{\link{read_softmax6_template}}, or create a data frame where each
row contains information about a well (in the \code{Well} column), and
other columns specify the value of an experimental variable (e.g., drug
concentration).}

\item{...}{Additional arguments passed to \code{\link[base]{merge}}}
}
\value{
A data frame
}
\description{
\code{apply_template} combines plate read data with metadata from a template,
producing a data frame that contains both the read values along with
additional information such as strain, medium, drug concentration, etc.
}
\details{
By default, the resulting data frame will contain data only for the wells
specified in the template. To include all wells in the plate data (but not
necessarily also in the template), use the argument \code{all.x = TRUE}. To
include all wells specified in both, use the argument \code{all = TRUE}.
}
\examples{
\dontrun{
library(softermax)

d1 <- read_softmax_xml("myfile.xml")
p1 <- d1$experiments[["Experiment#1"]]$plates[["Plate#1"]]
template <- read_softmax_template("plate_template.txt")

annotated <- apply_template(p1, template)
}

}
