% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fetchEDIT_tools.R
\name{get_EDIT_ecoclass_by_geoUnit}
\alias{get_EDIT_ecoclass_by_geoUnit}
\title{Get Ecological Dynamics Information Tool (EDIT) ecological sites by catalog (ESD/ESG) and MLRA}
\usage{
get_EDIT_ecoclass_by_geoUnit(geoUnit, catalog = c("esd", "esg"))
}
\arguments{
\item{geoUnit}{A character vector of \code{geoUnit} codes e.g. \code{c("018X","022A")} for MLRAs 18 and 22A.}

\item{catalog}{Catalog ID. One of: \code{"esd"} or \code{"esg"}}
}
\value{
A \code{data.frame} containing: \code{geoUnit}, \code{id}, \code{legacyId}, \code{name}. \code{NULL} if no result.
}
\description{
Data are accessed via Ecological Dynamics Interpretive Tool (EDIT) web services: https://edit.jornada.nmsu.edu/resources/esd. \code{geoUnit} refers to MLRA codes, possibly with a leading zero and trailing "X" for two digit MLRA symbols.
}
\examples{
\dontshow{if (curl::has_internet()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
\dontshow{\}) # examplesIf}
\dontrun{
   get_EDIT_ecoclass_by_geoUnit(c("018X","022A"))
}
}
