% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_soo_function.R
\name{plot_1d_soo_function}
\alias{plot_1d_soo_function}
\title{Plot a test function in 1D.}
\usage{
plot_1d_soo_function(
  fn,
  lower = lower_bounds(fn),
  upper = upper_bounds(fn),
  n = 1001L,
  xlab,
  ylab,
  main = function_name(fn),
  log = FALSE,
  rank = FALSE,
  ...
)
}
\arguments{
\item{fn}{[\code{\link{soo_function}}] Function to plot.}

\item{lower}{[\code{numeric}] Lower bounds of x1 and x2.}

\item{upper}{[\code{numeric}] Upper bounds of x1 and x2.}

\item{n}{[\code{integer(1)}] Number of locations at which to sample the function.}

\item{xlab}{[\code{character(1)}] Label of x (x1) axes.}

\item{ylab}{[\code{character(1)}] Label of y (x2) axes.}

\item{main}{[\code{character(1)}] Main title of plot.}

\item{log}{[\code{boolean(1)}] If \code{TRUE}, the z axes is plotted on log scale.}

\item{rank}{[\code{boolean(1)}] If \code{TRUE}, instead of the y values, their ranks are drawn.}

\item{...}{Ignored.}
}
\description{
Plot a test function in 1D.
}
\author{
Olaf Mersmann \email{olafm@p-value.net}
}
