\name{SOS}
\Rdversion{1.1}

\docType{class}

\alias{SOS}
\alias{SOS-class}
\alias{show,SOS-method}
\alias{print,SOS-method}
\alias{toString,SOS-method}

\alias{SOS_1.0.0}
\alias{SOS_1.0.0-class}
\alias{show,SOS_1.0.0-method}
\alias{print,SOS_1.0.0-method}
\alias{toString,SOS_1.0.0-method}

\alias{SOS_2.0.0}
\alias{SOS_2.0.0-class}
\alias{show,SOS_2.0.0-method}
\alias{print,SOS_2.0.0-method}
\alias{toString,SOS_2.0.0-method}

\alias{SOS_versioned}
\alias{SOS_versioned-class}

\alias{sosCapabilitiesDocumentOriginal}
\alias{sosCapabilitiesDocumentOriginal,SOS-method}

\alias{sosCaps}
\alias{sosCaps-methods}
\alias{sosCaps,SOS-method}

\alias{sosContents}
\alias{sosContents-methods}
\alias{sosContents,SOS-method}

\alias{sosDataFieldConverters}
\alias{sosDataFieldConverters-methods}
\alias{sosDataFieldConverters,SOS-method}
\alias{sosDataFieldConverters,SOS_Test-method}

\alias{sosTime}
\alias{sosTime-methods}
\alias{sosTime,SOS-method}
\alias{sosTime,list-method}

\alias{sosFilter_Capabilities}
\alias{sosFilter_Capabilities-methods}
\alias{sosFilter_Capabilities,SOS-method}

\alias{sosFeaturesOfInterest}
\alias{sosFeaturesOfInterest-methods}
\alias{sosFeaturesOfInterest,SOS-method}
\alias{sosFeaturesOfInterest,SOS,character-method}
\alias{sosFeaturesOfInterest,SosObservationOffering-method}

\alias{sosBinding}
\alias{sosBinding-methods}
\alias{sosBinding,SOS-method}
\alias{sosBinding,SOS_1.0.0-method}
\alias{sosBinding,SOS_2.0.0-method}

\alias{sosObservedProperties}
\alias{sosObservedProperties-methods}
\alias{sosObservedProperties,SOS-method}
\alias{sosObservedProperties,SosObservationOffering-method}

\alias{sosOfferingIds}
\alias{sosOfferingIds-methods}
\alias{sosOfferingIds,SOS-method}

\alias{sosOfferings}
\alias{sosOfferings-methods}
\alias{sosOfferings,SOS-method}
\alias{sosOfferings,SOS,character-method}

\alias{sosOperation}
\alias{sosOperation-methods}
\alias{sosOperation,SOS,character-method}

\alias{sosOperationsMetadata}
\alias{sosOperationsMetadata-methods}
\alias{sosOperationsMetadata,SOS-method}

\alias{sosParsers}
\alias{sosParsers-methods}
\alias{sosParsers,SOS-method}
\alias{sosParsers,SOS_Test-method}

\alias{sosProcedures}
\alias{sosProcedures-methods}
\alias{sosProcedures,SOS-method}
\alias{sosProcedures,list-method}
\alias{sosProcedures,SosObservationOffering-method}

\alias{sosResponseFormats}
\alias{sosResponseFormats-methods}
\alias{sosResponseFormats,SOS-method}
\alias{sosResponseFormats,OwsOperation-method}
\alias{sosResponseFormats,SosObservationOffering-method}

\alias{sosOutputFormats}
\alias{sosOutputFormats-methods}
\alias{sosOutputFormats,SOS-method}
\alias{sosOutputFormats,OwsOperation-method}

\alias{sosResponseMode}
\alias{sosResponseMode-methods}
\alias{sosResponseMode,SOS-method}
\alias{sosResponseMode,OwsOperation-method}
\alias{sosResponseMode,SosObservationOffering-method}

\alias{sosResultModels}
\alias{sosResultModels-methods}
\alias{sosResultModels,SOS-method}
\alias{sosResultModels,OwsOperation-method}

\alias{sosResult,character-method}

\alias{sosServiceIdentification}
\alias{sosServiceIdentification-methods}
\alias{sosServiceIdentification,SOS-method}
\alias{sosServiceProvider}
\alias{sosServiceProvider-methods}
\alias{sosServiceProvider,SOS-method}
\alias{sosSrsName}
\alias{sosSrsName-methods}
\alias{sosSrsName,SOS-method}
\alias{sosTimeFormat}
\alias{sosTimeFormat-methods}
\alias{sosTimeFormat,SOS-method}

\alias{sosUrl}
\alias{sosUrl-methods}
\alias{sosUrl,SOS-method}
\alias{sosUrl,SOS_1.0.0-method}
\alias{sosUrl,SOS_2.0.0-method}

\alias{sosVersion}
\alias{sosVersion-methods}
\alias{sosVersion,SOS-method}
\alias{sosExceptionCodeMeaning}
\alias{sosExceptionCodeMeaning,character-method}
\alias{sosBoundedBy}
\alias{sosBoundedBy-method}
\alias{sosBoundedBy,list-method}
\alias{sosCoordinates}
\alias{sosCoordinates-method}
\alias{sosCoordinates,list-method}
\alias{sosCoordinates,SosObservationOffering-method}

\alias{sosId}
\alias{sosId-method}
\alias{sosId,list-method}
\alias{sosSrsName}
\alias{sosSrsName-method}

\alias{sosFeatureIds}
\alias{sosFeatureIds-method}
\alias{sosFeatureIds,list-method}
\alias{sosObservedProperties,list-method}
\alias{sosFeaturesOfInterest,list-method}

\alias{sosGetCRS}
\alias{sosGetCRS-method}
\alias{sosGetCRS,SOS-method}
\alias{sosGetCRS,list-method}
\alias{sosGetCRS,character-method}
\alias{sosGetCRS,SosObservationOffering-method}

\alias{sosName}
\alias{sosName-method}
\alias{sosName,list-method}
\alias{sosName,OwsServiceProvider-method}
\alias{sosName,OwsGetCapabilities-method}
\alias{sosName,OwsOperation-method}
\alias{sosName,SosDescribeSensor-method}
\alias{sosName,SosGetObservation-method}
\alias{sosName,SosGetObservationById-method}

\alias{sosTitle}
\alias{sosTitle-method}
\alias{sosTitle,SOS-method}

\alias{sosAbstract}
\alias{sosAbstract-method}
\alias{sosAbstract,SOS-method}

\alias{sosEncoders}
\alias{sosEncoders,SOS-method}

\alias{sosOperations}
\alias{sosOperations,SOS-method}
\alias{sosOperations,OwsCapabilities-method}
\alias{sosOperations,SosCapabilities_1.0.0-method}
\alias{sosOperations,SosCapabilities_2.0.0-method}

\alias{sosGetDCP}
\alias{sosGetDCP,SOS,character-method}

\alias{sosSwitchCoordinates}
\alias{sosSwitchCoordinates-method}
\alias{sosSwitchCoordinates,SOS-method}

\alias{plot.SOS}
\alias{plot,SOS,missing-method}
\alias{plot.SosObservationOffering}
\alias{plot,SosObservationOffering,missing-method}

\alias{print.summary.SOS}
\alias{print.summary.SosObservationOffering}

\alias{summary.SosObservationOffering}
\alias{summary.SOS}
\alias{summary.SOS_versioned}

\alias{sosResult,data.frame-method}

\alias{sosUOM}
\alias{sosUOM,list-method}
\alias{sosUOM,data.frame-method}

\alias{sosCapabilitiesUrl}
\alias{sosCapabilitiesUrl-method}
\alias{sosCapabilitiesUrl,SOS-method}

\alias{SOS_Test}
\alias{SOS_Test-class}

% Version 2.0.0
\alias{sosName,SosGetFeatureOfInterest_2.0.0-method}
\alias{sosName,SosGetObservation_2.0.0-method}
\alias{sosProcedures,SosObservationOffering_2.0.0-method}
\alias{sosResponseFormats,SosObservationOffering_2.0.0-method}
\alias{sosTime,SosObservationOffering_2.0.0-method}
\alias{SOS_2.0.0-class}
\alias{print,SOS_2.0.0-method}
\alias{show,SOS_2.0.0-method}
\alias{sosBinding,SOS_2.0.0-method}
\alias{sosUrl,SOS_2.0.0-method}
\alias{toString,SOS_2.0.0-method}
\alias{sosFeaturesOfInterest,SOS_2.0.0-method}

\title{Class, and Construction and Accessor Functions for "SOS"}

\description{Base class of a connection to a Sensor Observation Service.}

\section{Objects from the Class}{
Objects can be created by calls to the construction function of the form \code{SOS(...)}.

Object from the class can be used in calls to function for metadata retrieval of sensors (\code{link{describeSensor-methods}}) and observation data queries (\code{link{getObservation-methods}} and \code{link{getObservationById-methods}})
}

\section{Slots}{
  \describe{
    \item{\code{url}:}{Object of class \code{"character"}: The endpoint of the service, e.g. \code{http://myUrl.org/SOS1/sos}.}
    \item{\code{binding}:}{Object of class \code{"character"}: The binding, or transport protocol, see \code{\link{SosSupportedBindings}} for available ones.}
    \item{\code{version}:}{Object of class \code{"character"}: The connected service's version, e.g. \code{"1.0.0"}.}
    \item{\code{capabilities}:}{Object of class \code{"OwsCapabilities"} ~~ }
    \item{\code{parsers}:}{Object of class \code{"list"}: A list of named functions for parsing of SOS responses.}
    \item{\code{encoders}:}{Object of class \code{"list"}: A list of named functions for encoding of SOS requests.}
    \item{\code{dataFieldConverters}:}{Object of class \code{"list"}: A list of named functions to be used by the parsing methods to convert data values to the correct \R type, see \code{\link{SosDataFieldConvertingFunctions}} for the default functions and how to add your own converters.}
    \item{\code{timeFormat}:}{Object of class \code{"character"}: The time format to be used or decoding and encoding time character strings to and from \code{POSIXt} classes.}
    \item{\code{verboseOutput}:}{Object of class \code{"logical"}: Trigger parameter for extensive debugging information on the console.}
    \item{\code{switchCoordinates}:}{Object of class \code{"logical"}: Trigger enabling switching of lat/long during parsing stage.}
    \item{\code{useDCPs}:}{Object of class \code{"logical"}: Trigger for not using DCP endpoints from the capabilities but just the URL defined when creating the SOS connection. If there is a specific endpoint for a specific binding the user must make sure the configured binding and DCP match.}
    \item{\code{dcpFilter}:}{Object of class \code{"list"}: Named list of regular expressions to be applied (using \code{grep}) to DCPs if there is more than one for the chosen binding.}
    \item{\code{addtionalKVPs}:}{A nam of class \code{"list"}: Named list of key-value-pairs to be appended to an KVP request.}
  }
}

\section{Methods}{
  \describe{
    \item{sosAbstract}{\code{signature(obj = "SOS")}: ... }
    \item{sosBinding}{\code{signature(sos = "SOS")}: The protocol used for a connection to the service. }
    \item{sosCapabilitiesDocumentOriginal}{\code{signature(sos = "SOS")}: To retrieve the full original service metadata document.}
    \item{sosCaps}{\code{signature(sos = "SOS")}: ... }
    \item{sosContents}{\code{signature(sos = "SOS")}: ... }
    \item{sosDataFieldConverters}{\code{signature(sos = "SOS")}: ... }
    \item{sosTime}{\code{signature(obj = "SOS")}: ... }
    \item{sosTime}{\code{signature(obj = "SOS")}: ... }
    \item{sosTitle}{\code{signature(obj = "SOS")}: ... }
    \item{sosOperations}{\code{signature(sos = "...")}: ... }
    \item{sosGetCRS}{\code{signature(obj = "character")}: ... }
    \item{sosGetDCP}{\code{signature(sos = "SOS", operation = "character", type = "character")}: Get the distributed computing platform URL for the given operation and method type. If type is missing, the function returns all available DCPs. }
    \item{sosEncoders}{\code{signature(sos = "SOS")}: ... }
    \item{sosFeatureIds}{\code{signature(obj = "list")}: ... }
    \item{sosFeaturesOfInterest}{\code{signature(obj = "list")}: ... }
    \item{sosGetCRS}{\code{signature(obj = "character")}: Get an object of class \code{sp:::CRS} for a given OGC URN depicting a reference system, like \code{urn:ogc:def:crs:EPSG:1000}.}
    \item{sosName}{\code{signature(obj = "...")}: ... }
    \item{sosObservedProperties}{\code{signature(sos = "SOS")}: ... }
    \item{sosOffering}{\code{signature(sos = "SOS", offeringId = "character")}: ... }
    \item{sosOfferingIds}{\code{signature(sos = "SOS")}: ... }
    \item{sosOfferings}{\code{signature(sos = "SOS")}: ... }
    \item{sosOperation}{\code{signature(sos = "SOS", operationName = "character")}: ... }
    \item{sosOperationsMetadata}{\code{signature(sos = "SOS")}: ... }
    \item{sosParsers}{\code{signature(sos = "SOS")}: ... }
    \item{sosProcedures}{\code{signature(sos = "SOS")}: Accessor function for the procedures of a \code{\linkS4class{SOS}} (via list in capabilities of \code{GetObservation} operation) or a \code{\linkS4class{SosObservationOffering}}.}
    \item{sosResponseFormats}{\code{signature(sos = "SOS")}: TBD: add missing signatures ... }
    \item{sosResponseMode}{\code{signature(sos = "SOS")}: ... }
    \item{sosResultModels}{\code{signature(sos = "SOS")}: ... }
    \item{sosServiceIdentification}{\code{signature(sos = "SOS")}: ... }
    \item{sosServiceProvider}{\code{signature(sos = "SOS")}: ... }
    \item{sosSrsName}{\code{signature(sos = "SOS")}: ... }
    \item{sosSwitchCoordinates}{\code{signature(sos = "SOS")}: ... }
    \item{sosTimeFormat}{\code{signature(sos = "SOS")}: ... }
    \item{sosUrl}{\code{signature(sos = "SOS")}: ... }
    \item{sosVersion}{\code{signature(sos = "SOS")}: ... }
    \item{sosTime}{\code{signature(obj = "SOS")}: Accessor function for the event time period from the GetObservation operations metadata.}
    \item{sosFilter_Capabilities}{\code{signature(sos = "SOS")}: Accessor function for the filter capabilities of a SOS object.}
    \item{describeSensor}{\code{signature(sos = "SOS_2.0.0", procedure = "character")}: ... }
    \item{getCapabilities}{\code{signature(sos = "SOS_2.0.0")}: ... }
    \item{getDataAvailability}{\code{signature(sos = "SOS_2.0.0")}: ... }
    \item{getFeatureOfInterest}{\code{signature(sos = "SOS_2.0.0", featureOfInterest = "ANY")}: ... }
    \item{getFeatureOfInterest}{\code{signature(sos = "SOS_2.0.0", featureOfInterest = "character")}: ... }
    \item{getObservationById}{\code{signature(sos = "SOS_2.0.0", observationId = "character")}: ... }
    \item{getObservation}{\code{signature(sos = "SOS_2.0.0", offering = "character")}: ... }
    \item{getObservation}{\code{signature(sos = "SOS_2.0.0", offering = "SosObservationOffering_2.0.0")}: ... }
    \item{sosBinding}{\code{signature(sos = "SOS_2.0.0")}: ... }
    \item{sosRequest}{\code{signature(sos = "SOS_2.0.0", request = "OwsServiceOperation", verbose = "logical", inspect = "logical")}: ... }
    \item{sosUrl}{\code{signature(sos = "SOS_2.0.0")}: access the endpoint of the SOS object.}
	 }
}

\usage{
SOS(url,
    binding = SosDefaultBinding(),
    version = sos100_version,
    parsers = SosParsingFunctions(),
    encoders = SosEncodingFunctions(),
    dataFieldConverters = SosDataFieldConvertingFunctions(),
    timeFormat = sosDefaultTimeFormat, verboseOutput = FALSE,
    switchCoordinates = FALSE,
    useDCPs = TRUE,
    dcpFilter = SosDefaultDCPs(),
    additionalKVPs = list(),
    namespaces = SosAllNamespaces(version = version),
    ...)

SOS_Test(name = "test",
         binding = SosDefaultBinding(),
         version = sos100_version,
         parsers = SosParsingFunctions(),
         encoders = SosEncodingFunctions(),
         dataFieldConverters = SosDataFieldConvertingFunctions(),
         timeFormat = sosDefaultTimeFormat,
         verboseOutput = FALSE,
         switchCoordinates = FALSE,
         useDCPs = TRUE,
         dcpFilter = SosDefaultDCPs(),
         additionalKVPs = list(),
         namespaces = SosAllNamespaces(version = version),
         ...)
}

\arguments{
  \item{url}{See the corresponding slot description.}
  \item{binding}{See the corresponding slot description.}
  \item{version}{See the corresponding slot description.}
  \item{parsers}{See the corresponding slot description.}
  \item{encoders}{See the corresponding slot description.}
  \item{dataFieldConverters}{See the corresponding slot description.}
  \item{timeFormat}{See the corresponding slot description.}
  \item{verboseOutput}{See the corresponding slot description.}
  \item{switchCoordinates}{See the corresponding slot description.}
  \item{useDCPs}{See the corresponding slot description.}
  \item{dcpFilter}{See the corresponding slot description.}
  \item{additionalKVPs}{See the corresponding slot description.}
  \item{name}{Name of the test SOS class.}
  \item{namespaces}{Namespace definitions to be used for parsing and encoding or responses and requests, passed to \code{ns} argument of \pkg{xml2} functions.}
  \item{...}{Additional parameters that are passed on to the \code{\link{getObservation}} call that is done within this function.}
}

\value{The construction functions returns an object of class \code{\link{SOS-class}}.}

\details{
From the introduction of the specification document: \dQuote{The goal of SOS is to provide access to observations from sensors and sensor systems in a standard way that is consistent for all sensor systems including remote, in-situ, fixed and mobile sensors.}
}

\references{
Na, A., Priest, M. (Eds.), Sensor Observation Service, Open Geospatial Consortium Inc., OGC 06-009r6, Version: 1.0

The document is available for download at \url{https://www.opengeospatial.org/standards/sos}.
}

\author{Daniel Nuest \email{daniel.nuest@uni-muenster.de}}

\seealso{See also creation function \code{\link{SOS}} and the package vignette for general description of use.}

\examples{
showClass("SOS")
showClass("SOS_2.0.0")

# create a SOS connection
mySOS <- SOS(url = "http://sensorweb.demo.52north.org/sensorwebtestbed/service/kvp",
             binding = "KVP")

# create the URL to a GET request for GetCapabilities
sosCapabilitiesUrl(mySOS)

# access details of the SOS connection and it's metadata
sosContents(mySOS)
sosTime(mySOS)
sosFeaturesOfInterest(mySOS)
sosBinding(mySOS)

\dontrun{
# create a SOS connetion with a specific connection method and time format
mysos <- SOS(url = "http://mysos.org/sos",
    binding = "KVP", timeFormat = "\%Y-\%m-\%d")

# turn on verbose output for all methods and functions
SOS(url = "http://mysos.org/sos", verboseOutput = TRUE)

# get the meaning of an exception code
sosExceptionCodeMeaning(ex@exceptionCode)

# create a CRS object from a URN CRS string
sosGetCRS("urn:ogc:def:crs:EPSG:4217")

# create a SOS for a specific binding at a specific endpoint
SOS(url = "http://localhost:8080/52n-sos/sos/pox", binding = "POX",
		useDCPs = FALSE)

# create a SOS using only the DCPs from the capabilities that match a specific
# pattern with the default binding
SOS(url = "http://localhost:8080/52n-sos/sos/service",
		dcpFilter = list("POX" = "/pox"))
}

}

\keyword{classes}
