% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/soundcorrs.R
\name{scOne}
\alias{scOne}
\title{Constructor function for the \code{scOne} class.}
\usage{
scOne(data, name, col.aligned, transcription, separator = "\\\\|")
}
\arguments{
\item{data}{[data.frame] Data for one language.}

\item{name}{[character] Name of the language.}

\item{col.aligned}{[character] Name of the column with the aligned words.}

\item{transcription}{[transcription] The \code{\link{transcription}} for the given language.}

\item{separator}{[character] String used to separate segments in \code{col.aligned}. Defaults to \code{"\\|"}.}
}
\value{
[scOne] A \code{scOne} object containing the data and metadata for one language.
}
\description{
Take a data frame containing data for one language, in the wide format, and combine it with metadata into a \code{scOne} object. In a normal workflow, the user should have no need to invoke this function other than through \code{\link{read.scOne}}.
}
\section{Fields}{

\describe{
\item{\code{cols}}{[character list] Names of important columns.}

\item{\code{data}}{[data.frame] The original data.}

\item{\code{name}}{[character] Name of the language.}

\item{\code{segms}}{[character list] Words exploded into segments. With linguistic zeros preserved (\code{$z}) or removed (\code{$nz}).}

\item{\code{segpos}}{[integer list] A lookup list to check which character belongs to which segment. Counted with linguistic zeros preserved (\code{$z}) and removed (\code{$nz}).}

\item{\code{separator}}{[character] The string used as segment separator in \code{col.aligned}.}

\item{\code{trans}}{[transcription] The \code{\link{transcription}} object for the language.}

\item{\code{words}}{[character list] Words obtained by removing separators from the \code{col.aligned} column. With linguistic zeros (\code{$z}) or without them (\code{$nz}).}
}}

\examples{
fNameData <- system.file ("extdata", "data-capitals.tsv", package="soundcorrs")
fNameTrans <- system.file ("extdata", "trans-common.tsv", package="soundcorrs")
readData <- read.table (fNameData, header=TRUE)
readTrans <- read.transcription (fNameTrans)
ger <- scOne (readData, "German", "ALIGNED.German", readTrans)
}
