% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/soundcorrs.R
\name{summary.list.multiFit}
\alias{summary.list.multiFit}
\title{A comparison of the results produced by \code{\link{fitTable}} or \code{\link{multiFit}}.}
\usage{
\method{summary}{list.multiFit}(object, metric = "rss", ...)
}
\arguments{
\item{object}{[list.multiFit] The output of \code{\link{fitTable}} or \code{\link{multiFit}}.}

\item{metric}{[character] The metric to extract from \code{object}. Available metrics are: "aic", "bic", "rss", and "sigma". Defaults to "rss".}

\item{...}{Unused; only for consistency with \code{\link{summary}}.}
}
\value{
A more human-friendly digest.
}
\description{
Take the output of \code{\link{fitTable}} or \code{\link{multiFit}}, extract a specific metric from the fits, and present them in the form of a table.
}
\examples{
set.seed (27)
dataset <- data.frame (X=1:10, Y=(1:10)^2+runif(10,-10,10))
models <- list (
	"model A" = list (
		formula = "Y ~ X^a",
		start = list (list(a=100), list(a=1))),
	"model B" = list (
		formula = "Y ~ a*(X+b)",
		start = list (list(a=1,b=1)))
	)
summary (multiFit(models,dataset))
summary (fitTable(models,as.matrix(dataset),1,vec2df.rank), "sigma")
}
