% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/soundcorrs.R
\name{summary.soundcorrs}
\alias{summary.soundcorrs}
\title{Generate a segment-to-segment contingency table for two languages.}
\usage{
\method{summary}{soundcorrs}(object, count = "a", unit = "w", direction = 1, ...)
}
\arguments{
\item{object}{[soundcorrs] The dataset from which to draw frequencies. Only datasets with two languages are supported.}

\item{count}{[character] Report the absolute number of times or words, or relative to how many times or in how many words the given segments co-occur in L1 or L2. Accepted values are \code{"a(bs(olute))"} and \code{"r(el(ative))"}. Defaults to "a".}

\item{unit}{[character] Count how many times a correspondence occurs or in how many words it occurs. Accepted values are \code{"o(cc(ur(ence(s))))"} and \code{"w(or(d(s)))"}. Defaults to \code{"w"}.}

\item{direction}{[integer] If \code{1}, correspondences are in the order Language1 > Language2 ("x yields y"). If \code{2}, the order is Language2 < Language1 ("y originates from x"). Defaults to \code{1}.}

\item{...}{Unused; only for consistency with \code{\link{print}}.}
}
\value{
[table] The contingency table.
}
\description{
Produce a contingency table detailing all segment-to-segment correspondences in a dataset.
}
\examples{
dataset <- sampleSoundCorrsData.abc
summary (dataset)
round (summary(dataset,count="r"), digits=3)
summary (dataset, unit="o")
summary (dataset, direction=2)
}
