% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utilities_analyze.R
\name{analyzeFrame}
\alias{analyzeFrame}
\title{Analyze fft frame}
\usage{
analyzeFrame(
  frame,
  bin,
  freqs,
  autoCorrelation = NULL,
  samplingRate,
  scaleCorrection,
  loudness,
  cutFreq,
  trackPitch = TRUE,
  pitchMethods = c("dom", "autocor"),
  nCands,
  pitchDom = list(),
  pitchAutocor = list(),
  pitchCep = list(),
  pitchSpec = list(),
  pitchHps = list(),
  pitchFloor,
  pitchCeiling
)
}
\arguments{
\item{frame}{the abs spectrum of a frame, as returned by
\code{\link[stats]{fft}}}

\item{bin}{spectrogram bin width, Hz}

\item{freqs}{frequency per bin of spectrogram}

\item{autoCorrelation}{pre-calculated autocorrelation of the input frame
(computationally more efficient than to do it here)}

\item{samplingRate}{sampling rate (Hz)}

\item{loudness}{a list of parameters passed to \code{\link{getLoudness}} for
measuring subjective loudness, namely \code{SPL_measured, Pref,
spreadSpectrum}. NULL = skip loudness analysis}

\item{cutFreq}{if specified, spectral descriptives (peakFreq, specCentroid,
specSlope, and quartiles) are calculated only between \code{cutFreq[1]} and
\code{cutFreq[2]}. If a single number is given, analyzes frequencies from 0
to \code{cutFreq}. For ex., when analyzing recordings with varying sampling
rates, set to half the lowest sampling rate to make the spectra more
comparable. Note that "entropyThres" applies only to this frequency range,
which also affects which frames will not be analyzed with pitchAutocor.}

\item{trackPitch}{if TRUE, attempt to find F0 in this frame (FALSE if entropy
is above some threshold - specified in \code{\link{analyze}})}

\item{pitchMethods}{methods of pitch estimation to consider for determining
pitch contour: 'autocor' = autocorrelation (~PRAAT), 'cep' = cepstral,
'spec' = spectral (~BaNa), 'dom' = lowest dominant frequency band, 'hps' =
harmonic product spectrum, NULL = no pitch analysis}

\item{nCands}{maximum number of pitch candidates per method, normally 1...4
(except for \code{dom}, which returns at most one candidate per frame)}

\item{pitchDom}{a list of control parameters for pitch tracking using the
lowest dominant frequency band or "dom" method; see details and
\code{?soundgen:::getDom}}

\item{pitchAutocor}{a list of control parameters for pitch tracking using the
autocorrelation or "autocor" method; see details and
\code{?soundgen:::getPitchAutocor}}

\item{pitchCep}{a list of control parameters for pitch tracking using the
cepstrum or "cep" method; see details and \code{?soundgen:::getPitchCep}}

\item{pitchSpec}{a list of control parameters for pitch tracking using the
BaNa or "spec" method; see details and \code{?soundgen:::getPitchSpec}}

\item{pitchHps}{a list of control parameters for pitch tracking using the
harmonic product spectrum or "hps" method; see details and
\code{?soundgen:::getPitchHps}}

\item{pitchFloor}{absolute bounds for pitch candidates (Hz)}

\item{pitchCeiling}{absolute bounds for pitch candidates (Hz)}
}
\value{
Returns a list with two components: $pitchCands_frame contains pitch
  candidates for the frame, and $summaries contains other acoustic predictors
  like HNR, specSlope, etc.
}
\description{
Internal soundgen function.
}
\details{
This function performs the heavy lifting of pitch tracking and acoustic
analysis in general: it takes the spectrum of a single fft frame as input and
analyzes it.
}
\keyword{internal}
