% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fnn.R
\name{fnn}
\alias{fnn}
\alias{fnn,sf-method}
\alias{fnn,SpatRaster-method}
\title{false nearest neighbours}
\usage{
\S4method{fnn}{sf}(
  data,
  target,
  lib = NULL,
  pred = NULL,
  E = 1:10,
  tau = 1,
  nb = NULL,
  rt = 10,
  eps = 2,
  threads = detectThreads(),
  detrend = TRUE
)

\S4method{fnn}{SpatRaster}(
  data,
  target,
  lib = NULL,
  pred = NULL,
  E = 1:10,
  tau = 1,
  rt = 10,
  eps = 2,
  threads = detectThreads(),
  detrend = TRUE
)
}
\arguments{
\item{data}{observation data.}

\item{target}{name of target variable.}

\item{lib}{(optional) libraries indices.}

\item{pred}{(optional) predictions indices.}

\item{E}{(optional) embedding dimensions.}

\item{tau}{(optional) step of spatial lags.}

\item{nb}{(optional) neighbours list.}

\item{rt}{(optional) escape factor.}

\item{eps}{(optional) neighborhood diameter.}

\item{threads}{(optional) number of threads to use.}

\item{detrend}{(optional) whether to remove the linear trend.}
}
\value{
A vector
}
\description{
false nearest neighbours
}
\examples{
columbus = sf::read_sf(system.file("case/columbus.gpkg", package="spEDM"))
\donttest{
fnn(columbus,"crime")
}
}
\references{
Kennel M. B., Brown R. and Abarbanel H. D. I., Determining embedding dimension for phase-space reconstruction using a geometrical construction, Phys. Rev. A, Volume 45, 3403 (1992).
}
