% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/isochrones_sf.R
\name{calc_isochrones}
\alias{calc_isochrones}
\title{Isochrones calculation}
\usage{
calc_isochrones(
  lines,
  dists,
  start_points,
  mindist = 1,
  weight = NULL,
  direction = NULL
)
}
\arguments{
\item{lines}{A feature collection of lines representing the edges of the network}

\item{dists}{A vector of the size of the desired isochrones}

\item{start_points}{A feature collection of points representing the starting
points if the isochrones}

\item{mindist}{The minimum distance between two points. When two points are
too close, they might end up snapped at the same location on a line.
Default is 1.}

\item{weight}{The name of the column in lines to use an edge weight. If NULL,
the geographical length is used. Note that if lines are split during the
network creation, the weight column is recalculated proportionally to the new lines
length.}

\item{direction}{The name of the column indicating authorized
travelling direction on lines. if NULL, then all lines can be used in both
directions (undirected). The values of the column must be "FT" (From - To),
"TF" (To - From) or "Both".}
}
\value{
A feature collection of lines representing the isochrones with the
following columns
\itemize{
        \item point_id: the index of the point at the centre of the isochrone;
        \item distance: the size of the isochrone
}
}
\description{
Calculate isochrones on a network
}
\details{
An isochrone is the set of reachable lines around a node in a network within
a specified distance (or time). This function perform dynamic segmentation to return the
part of the edges reached and not only the fully covered edges. Several start points and
several distances can be given. The network can also be directed. The lines returned
by the function are the most accurate representation of the isochrones. However, if
polygons are required for mapping, the vignette "Calculating isochrones" shows
how to create smooth polygons from the returned sets of lines.
}
\examples{
library(sf)
# creating a simple network
wkt_lines <- c(
  "LINESTRING (0.0 0.0, 5.0 0.0)",
  "LINESTRING (0.0 -5.0, 5.0 -5.0)",
  "LINESTRING (5.0 0.0, 5.0 5.0)",
  "LINESTRING (5.0 -5.0, 5.0 -10.0)",
  "LINESTRING (5.0 0.0, 5.0 -5.0)",
  "LINESTRING (5.0 0.0, 10.0 0.0)",
  "LINESTRING (5.0 -5.0, 10.0 -5.0)",
  "LINESTRING (10.0 0, 10.0 -5.0)",
  "LINESTRING (10.0 -10.0, 10.0 -5.0)",
  "LINESTRING (15.0 -5.0, 10.0 -5.0)",
  "LINESTRING (10.0 0.0, 15.0 0.0)",
  "LINESTRING (10.0 0.0, 10.0 5.0)")

linesdf <- data.frame(wkt = wkt_lines,
                      id = paste("l",1:length(wkt_lines),sep=""))

lines <- st_as_sf(linesdf, wkt = "wkt")

# and the definition of the starting point
start_points <- data.frame(x=c(5),
                           y=c(-2.5))
start_points <- st_as_sf(start_points, coords = c("x","y"))

# setting the directions

lines$direction <- "Both"
lines[6,"direction"] <- "TF"

isochrones <- calc_isochrones(lines, dists = c(10,12),
                              start_points = start_points,
                              direction = "direction")
}
