% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/temporal_nkde_sf.R
\name{simple_tnkde}
\alias{simple_tnkde}
\title{Simple TNKDE algorithm}
\usage{
simple_tnkde(
  graph,
  events,
  samples,
  samples_time,
  bws_net,
  bws_time,
  kernel_func,
  nodes,
  edges,
  div
)
}
\arguments{
\item{graph}{a graph object from igraph representing the network}

\item{events}{a feature collection of points representing the events. It must be
snapped on the network, and be nodes of the network. A column vertex_id
must indicate for each event its corresponding node}

\item{samples}{a feature collection of points representing the sampling points.
The samples must be snapped on the network. A column edge_id must indicate
for each sample on which edge it is snapped.}

\item{samples_time}{a numeric vector indicating when the densities must be
sampled}

\item{bws_net}{a vector indicating the network kernel bandwidth (in meters) for each
event}

\item{bws_time}{a vector indicating the time kernel bandwidth for each
event}

\item{kernel_func}{a function obtained with the function select_kernel}

\item{nodes}{a feature collection of points representing the nodes of the network}

\item{edges}{a feature collection of linestrings representing the edges of the network}

\item{div}{The divisor to use for the kernel. Must be "n" (the number of
events within the radius around each sampling point), "bw" (the bandwidth)
"none" (the simple sum).}
}
\value{
a list of two matrices. The first one ins the matrix of the densities,
the rows are the samples and the columns the time. The second has the same
dimensions and contains the number of events influencing each sample
}
\description{
Function to perform the simple tnkde.
}
\examples{
#This is an internal function, no example provided
}
\keyword{internal}
