% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/automap.R
\name{automap}
\alias{automap}
\title{Automatically create 2D and 3D maps using USGS and ESRI map data}
\usage{
automap(
  lat = NULL,
  lng = NULL,
  distance = 10,
  method = c("2d", "3d"),
  img.width = 600,
  img.height = 600,
  overlay = NULL,
  z = 9,
  overlay.alpha = 0.75,
  colorscale = "imhof4",
  color.intensity = 1,
  max.darken = 0.5,
  sun.angle = 315,
  sun.altitude = 45,
  water.cutoff = 0.999,
  water.min.area = length(heightmap)/400,
  water.max.height = NULL,
  solid = TRUE,
  shadow = TRUE,
  water = FALSE,
  waterdepth = 0,
  theta = 45,
  phi = 45,
  fov = 0,
  zoom = 1,
  save.file = c(FALSE, "tif", "png", TRUE),
  from.file = c(FALSE, "tif", "png", TRUE),
  tif.filename = NULL,
  png.filename = NULL,
  dist.unit = c("km", "miles", "m", "ft"),
  coord.unit = c("degrees", "radians"),
  sr_bbox = 4326,
  sr_image = 4326,
  print.map = TRUE
)
}
\arguments{
\item{lat}{The latitude for the map's centroid, in decimal degrees or
radians.}

\item{lng}{The longitude for the map's centroid, in decimal degrees or
radians.}

\item{distance}{The distance between the centroid and any corner of the
(square) output map to include.}

\item{method}{Should a 2d or 3d plot be produced?}

\item{img.width}{Image width, in pixels}

\item{img.height}{Image height, in pixels}

\item{overlay}{ESRI overlay map to include, if any -- see
\code{\link[spacey]{get_image_overlay}} for list of options. If specifying
a local file with \code{from.file}, any non \code{NULL} value will add your
local file as an overlay.}

\item{z}{zscale, passed to various rayshader functions. Defined as
the ratio between the x and y spacing (which are assumed to be equal)
and the z axis. For contiguous United States, USGS data is generally
available at a ~9 meter spacing, with elevation provided in meter increments,
resulting in a z value of 9 returning roughly representative maps; decrease
this value to exaggerate elevation features.}

\item{overlay.alpha}{Alpha value for the optional overlay layer.}

\item{colorscale}{Color scale for land and water elements. If a vector of
length 1, the same color scale will be applied for both land and water. If
greater than  length 1, values named "water" or "watercolor" will be used
for water coloring, while "land" or "landcolor" will be used for land.}

\item{color.intensity}{Intensity of color mapping -- higher values result in
more intense colors.}

\item{max.darken}{Passed to \code{\link[rayshader]{add_shadow}}. The lower
limit for how much the image will be darkened. 0 is completely black, 1 means
the shadow map will have no effect.}

\item{sun.angle}{Angle around the matrix from which lights originate. Values
line up with compass directions -- so 0 is directly North, while the default
315 places the sun in the Northwest.}

\item{sun.altitude}{Angle in degrees from horizon from which light
originates. Bounded [0, 90].}

\item{water.cutoff}{Passed to \code{\link[rayshader]{detect_water}}. Defined
therein as the lower limit of the z-component of the unit normal vector to
be classified as water.}

\item{water.min.area}{Passed to \code{\link[rayshader]{detect_water}}. The
minimum possible area to consider a body of water.}

\item{water.max.height}{Passed to \code{\link[rayshader]{detect_water}}. If
provided, the maximum height a point can be classified water.}

\item{solid}{Logical -- should the output be rendered as a solid
(\code{TRUE}) or just a surface (\code{FALSE})?}

\item{shadow}{Logical -- should shadows be rendered?}

\item{water}{Logical -- should water be rendered?}

\item{waterdepth}{Water level.}

\item{theta}{Rotation around z axis.}

\item{phi}{Azimuth angle.}

\item{fov}{Field of view angle.}

\item{zoom}{Zoom factor.}

\item{save.file}{Should the heightmap (\code{= "tif"}), overlay
(\code{= "png"}), or both (\code{= TRUE}) be saved? Default \code{FALSE}
saves neither.}

\item{from.file}{Should the map be built from local \code{.tif}
and \code{.png} files, rather than downloaded data? Accepts logical
\code{FALSE} (no local files used) and \code{TRUE} (local files used for both
height maps and textures, if requested), as well as strings \code{tif}
(only use height map, redownload PNG) and \code{png} (only use texture,
redownload tif). Overrides save arguments if local files are used.}

\item{tif.filename}{If \code{save.tif} is \code{TRUE}, filename to save the
\code{.tif} height map to. If \code{from.file} is \code{TRUE}, filename to
load the height map from.}

\item{png.filename}{If \code{save.png} is \code{TRUE}, filename to save the
\code{.png} texture to. If \code{from.file} is \code{TRUE}, filename to
load the texture from.}

\item{dist.unit}{Units for the distance argument. All units are converted to
kilometers, with some errors in the transition due to floating point
arithmetic -- so if high accuracy is needed, convert units to kilometers
beforehand.}

\item{coord.unit}{Units for latitude and longitude, in either decimal degrees
or radians.}

\item{sr_bbox}{Spatial reference code (ISO 19111) for bounding box}

\item{sr_image}{Spatial reference code (ISO 19111) for image}

\item{print.map}{Logical -- should the output map be printed?}
}
\value{
A rayshader map object, by default printed and returned invisibly.
}
\description{
This function takes a latitude/longitude coordinate pair alongside a desired
distance to map and retrieves USGS (and optionally ESRI) map data, converts
said data into matrices, and runs the data through \code{rayshader} using
sensible defaults in order to return a 2D shaded map relief. It requires a
functioning internet connection in order to retrieve data.
}
\examples{
\dontrun{
automap(44.121268, -73.903734)
automap(44.121268, -73.903734, overlay = "World_Imagery")
automap(44.121268, -73.903734, overlay = "World_Imagery", method = "3d")
}

}
\references{
Archuleta, C.M., Constance, E.W., Arundel, S.T., Lowe, A.J., Mantey, K.S.,
and Phillips, L.A., 2017, The National Map seamless digital elevation model
specifications: U.S. Geological Survey Techniques and Methods, book 11,
chap. B9, 39 p., https://doi.org/10.3133/tm11B9
}
