% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_bounding_box.R
\name{get_centroid_bounding_box}
\alias{get_centroid_bounding_box}
\title{Get bounding box for set of coordinate points}
\usage{
get_centroid_bounding_box(
  centroid,
  distance,
  lat = NULL,
  lng = NULL,
  dist.unit = c("km", "miles", "m", "ft"),
  coord.unit = c("degrees", "radians")
)
}
\arguments{
\item{centroid}{A vector of length 2 containing latitude and longitude
values.}

\item{distance}{The distance from the centroid to extend the bounding box.}

\item{lat}{A quoted string indicating what named value in the centroid
represents latitude. If NULL, will be inferred from centroid names.}

\item{lng}{A quoted string indicating what named value in the centroid
represents longitude. If NULL, will be inferred from centroid names.}

\item{dist.unit}{A single value representing the units the distance value
is in.}

\item{coord.unit}{A single value representing the units the coordinates are
in.}
}
\value{
A list of length 2, containing the bottom-left (named "bl") and
top-right (named "tr") coordinates of the bounding box.
}
\description{
Get bounding box for set of coordinate points
}
\examples{
get_centroid_bounding_box(c(
  "lat" = 44.121268,
  "lng" = -73.903734
),
distance = 10
)
}
