% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mrs_data_proc.R
\name{hsvd_filt}
\alias{hsvd_filt}
\title{HSVD based signal filter.}
\usage{
hsvd_filt(mrs_data, xlim = c(-30, 30), comps = 40, irlba = TRUE, max_damp = 10)
}
\arguments{
\item{mrs_data}{MRS data to be filtered.}

\item{xlim}{frequency range in Hz to filter.}

\item{comps}{number of Lorentzian components to use for modelling.}

\item{irlba}{option to use irlba SVD (logical).}

\item{max_damp}{maximum allowable damping factor.}
}
\value{
filtered data.
}
\description{
HSVD based signal filter described in:
Barkhuijsen H, de Beer R, van Ormondt D. Improved algorithm for noniterative
and timedomain model fitting to exponentially damped magnetic resonance
signals. J Magn Reson 1987;73:553-557.
}
