% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read_sas.R
\name{spark_read_sas}
\alias{spark_read_sas}
\title{Read in SAS datasets in .sas7bdat format into Spark by using the spark-sas7bdat Spark package.}
\usage{
spark_read_sas(sc, path, table)
}
\arguments{
\item{sc}{Connection to Spark local instance or remote cluster. See the example}

\item{path}{full path to the SAS file either on HDFS (hdfs://), S3 (s3n://), as well as the local file system (file://). 
Mark that files on the local file system need to be specified using the full path.}

\item{table}{character string with the name of the Spark table where the SAS dataset will be put into}
}
\value{
an object of class \code{tbl_spark}, which is a reference to a Spark DataFrame based on which
dplyr functions can be executed. See \url{https://github.com/rstudio/sparklyr}
}
\description{
Read in SAS datasets in .sas7bdat format into Spark by using the spark-sas7bdat Spark package.
}
\examples{
\dontrun{
## If you haven't got a Spark cluster, you can install Spark locally like this
library(sparklyr)
spark_install(version = "2.0.1")

## Define the SAS .sas7bdat file, connect to the Spark cluster to read + process the data
myfile <- system.file("extdata", "iris.sas7bdat", package = "spark.sas7bdat")
myfile

library(spark.sas7bdat)
sc <- spark_connect(master = "local")
x <- spark_read_sas(sc, path = myfile, table = "sas_example")
x

library(dplyr)
x \%>\% group_by(Species) \%>\%
  summarise(count = n(), length = mean(Sepal_Length), width = mean(Sepal_Width))
}
}
\references{
\url{https://spark-packages.org/package/saurfang/spark-sas7bdat}, \url{https://github.com/saurfang/spark-sas7bdat}, \url{https://github.com/rstudio/sparklyr}
}
\seealso{
\code{\link[sparklyr]{spark_connect}}, \code{\link[sparklyr]{sdf_register}}
}

