% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sparsebnUtils-generate.R
\name{random.graph}
\alias{random.graph}
\title{Generate random DAGs}
\usage{
random.graph(nnode, nedge, acyclic = TRUE, loops = FALSE,
  permute = TRUE)
}
\arguments{
\item{nnode}{Number of nodes in the graph.}

\item{nedge}{Number of edges in the graph.}

\item{acyclic}{If \code{TRUE}, output will be an acyclic graph.}

\item{loops}{If \code{TRUE}, output may include self-loops.}

\item{permute}{If \code{TRUE}, order of nodes will be randomly permuted.
If \code{FALSE}, output will be ordered according to its
topological sort, i.e. with a lower-triangular adjacency matrix.}
}
\value{
An \code{\link[sparsebnUtils]{edgeList}} object containing a list of parents for each node.
}
\description{
Generate a random graph with fixed number of edges.
}
