% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/estimate_risk.R
\name{estimate_risk}
\alias{estimate_risk}
\title{Calculate information criteria.}
\usage{
estimate_risk(object, x, y, type = c("AIC", "BIC", "GCV"), approx_df = FALSE)
}
\arguments{
\item{object}{fitted object from a call to \code{\link[=sparsegl]{sparsegl()}}.}

\item{x}{Double. A matrix of predictors, of dimension
\eqn{n \times p}{n * p}; each row
is a vector of measurements and each column is a feature. Objects of class
\code{\link[Matrix:sparseMatrix]{Matrix::sparseMatrix}} are supported.}

\item{y}{Double/Integer/Factor. The response variable.
Quantitative for \code{family="gaussian"}.
For \code{family="binomial"} should be either a factor with two levels or
a vector of integers taking 2 unique values.
For a factor, the last level in alphabetical order is the target class.}

\item{type}{one or more of AIC, BIC, or GCV.}

\item{approx_df}{the \code{df} component of a \code{\link[=sparsegl]{sparsegl()}} object is an
approximation (albeit a fairly accurate one) to the actual degrees-of-freedom.
However, the exact value requires inverting a portion of \verb{X'X}. So this
computation may take some time (the default computes the exact df).}
}
\value{
a \code{data.frame} with as many rows as \code{object$lambda}. It contains
columns \code{lambda}, \code{df}, and the requested risk types.
}
\description{
This function uses the degrees of freedom to calculate various information
criteria. This function uses the "unknown variance" version of the likelihood.
Only implemented for Gaussian regression. The constant is ignored (as in
\code{\link[stats:extractAIC]{stats::extractAIC()}}).
}
\examples{
n <- 100
p <- 20
X <- matrix(rnorm(n * p), nrow = n)
eps <- rnorm(n)
beta_star <- c(rep(5, 5), c(5, -5, 2, 0, 0), rep(-5, 5), rep(0, (p - 15)))
y <- X \%*\% beta_star + eps
groups <- rep(1:(p / 5), each = 5)
fit1 <- sparsegl(X, y, group = groups)
estimate_risk(fit1, X, y, type = "AIC")
}
\references{
Vaiter S, Deledalle C, Peyré G, Fadili J, Dossal C. (2012). \emph{The
Degrees of Freedom of the Group Lasso for a General Design}.
\url{https://arxiv.org/pdf/1212.6478.pdf}.
}
\seealso{
\code{\link[=sparsegl]{sparsegl()}} method.
}
