% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.cv.sparsegl.R
\name{plot.cv.sparsegl}
\alias{plot.cv.sparsegl}
\title{Plot cross-validation curves produced from a \code{cv.sparsegl} object.}
\usage{
\method{plot}{cv.sparsegl}(x, log_axis = c("xy", "x", "y", "none"), sign.lambda = 1, ...)
}
\arguments{
\item{x}{Fitted \code{\link[=cv.sparsegl]{cv.sparsegl()}} object}

\item{log_axis}{Apply log scaling to the requested axes.}

\item{sign.lambda}{Either plot against \code{log(lambda)} (default) or the
reverse if \code{sign.lambda < 0}.}

\item{...}{Not used.}
}
\description{
Plots the cross-validation curve, and upper and lower standard deviation
curves, as a function of the \code{lambda} values used. This function is
modified based on \code{\link[glmnet:plot.cv.glmnet]{glmnet::plot.cv.glmnet()}}.
}
\details{
A plot is produced, a \code{\link[ggplot2:ggplot]{ggplot2::ggplot()}} object. Additional user
modifications can be added as desired.
}
\examples{
n <- 100
p <- 20
X <- matrix(rnorm(n * p), nrow = n)
eps <- rnorm(n)
beta_star <- c(rep(5, 5), c(5, -5, 2, 0, 0), rep(-5, 5), rep(0, (p - 15)))
y <- X \%*\% beta_star + eps
groups <- rep(1:(p / 5), each = 5)
cv_fit <- cv.sparsegl(X, y, groups)
plot(cv_fit)
}
\seealso{
\code{\link[=cv.sparsegl]{cv.sparsegl()}}.
}
