% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fns.R
\name{cholsolveAQinvAT}
\alias{cholsolveAQinvAT}
\title{Solve the equation X = AQ^{-1}t(A) under permutations}
\usage{
cholsolveAQinvAT(Q = NULL, A = NULL, Lp = NULL, P = NULL)
}
\arguments{
\item{Q}{matrix (if of class \code{Matrix} needs to be column-compressed, i.e., \code{dgCMatrix} or \code{dsCMatrix})), the Cholesky factor of which needs to be found}

\item{A}{sparse or dense matrix}

\item{Lp}{the lower Cholesky factor of a permuted Q}

\item{P}{the permutation matrix}
}
\value{
x solution to \code{X = AQ^{-1}t(A)}
}
\description{
This function is a wrapper of \code{solve()} for finding \code{X = AQ^{-1}t(A)} when the permuted Cholesky factor of Q is known.
#'
}
\examples{
require(Matrix)
Q = sparseMatrix(i = c(1, 1, 2, 2),
                 j = c(1, 2, 1, 2),
                 x = c(0.1, 0.2, 0.2, 1))
X <- cholPermute(Q)
y <- matrix(c(1,2), 2, 1)
A <- y \%*\% t(y)
cholsolveAQinvAT(Q,A,X$Qpermchol,X$P)
}
\references{
Havard Rue and Leonhard Held (2005). Gaussian Markov Random Fields: Theory and Applications. Chapman & Hall/CRC Press
}
\keyword{Cholesky}
\keyword{factor,}
\keyword{linear}
\keyword{solve}
