% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simulateVARX.R
\name{simulateVARX}
\alias{simulateVARX}
\title{VARX simulation}
\usage{
simulateVARX(N, K, p, m, nobs, rho,
                    sparsityA1, sparsityA2, sparsityA3,
                    mu, method, covariance, ...)
}
\arguments{
\item{N}{dimension of the time series.}

\item{K}{TODO}

\item{p}{number of lags of the VAR model.}

\item{m}{TODO}

\item{nobs}{number of observations to be generated.}

\item{rho}{base value for the covariance matrix.}

\item{sparsityA1}{density (in percentage) of the number of nonzero elements
of the A1 block.}

\item{sparsityA2}{density (in percentage) of the number of nonzero elements
of the A2 block.}

\item{sparsityA3}{density (in percentage) of the number of nonzero elements
of the A3 block.}

\item{mu}{a vector containing the mean of the simulated process.}

\item{method}{which method to use to generate the VAR matrix. Possible values
are \code{"normal"} or \code{"bimodal"}.}

\item{covariance}{type of covariance matrix to use in the simulation. Possible
values: \code{"toeplitz"}, \code{"block1"}, \code{"block2"} or simply \code{"diagonal"}.}

\item{...}{the options for the simulation. These are:
\code{muMat}: the mean of the entries of the VAR matrices;
\code{sdMat}: the sd of the entries of the matrices;}
}
\value{
A a list of NxN matrices ordered by lag

data a list with two elements: \code{series} the multivariate time series and
\code{noises} the time series of errors

S the variance/covariance matrix of the process
}
\description{
This function generates a simulated multivariate VAR time series.
}
