% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/aleatory_analysis.R
\name{aa_sampleSizeSummary}
\alias{aa_sampleSizeSummary}
\title{Determines the median and maximum A-Test score observed for each sample size}
\usage{
aa_sampleSizeSummary(FILEPATH, SAMPLESIZES, MEASURES, SUMMARYFILENAME,
  ATESTRESULTS_FILE = NULL, ATESTRESULTS_OBJECT = NULL, TIMEPOINTS = NULL,
  TIMEPOINTSCALE = NULL, check_done = FALSE)
}
\arguments{
\item{FILEPATH}{Directory where the results of the simulation runs, in folders or in single CSV file format, can be found}

\item{SAMPLESIZES}{The sample sizes chosen (i.e. in our case, this would be an array containing 1,5,50,100,300,800}

\item{MEASURES}{An array containing the names of the simulation output measures to be analysed.}

\item{SUMMARYFILENAME}{Name of the file generated that lists the maximum and median A-Test results for each sample size.}

\item{ATESTRESULTS_FILE}{The name of a CSV file containing the A-Test
results calculated by aa_getATestResults, if reading from a CSV file.}

\item{ATESTRESULTS_OBJECT}{The name of an R object containing the A-Test
results calculated by aa_getATestResults, if not reading from a CSV file}

\item{TIMEPOINTS}{Implemented so this method can be used when analysing multiple simulation timepoints. If only analysing one timepoint, this should be set to NULL. If not, this should be an array of timepoints, e.g. c(12,36,48,60)}

\item{TIMEPOINTSCALE}{Implemented so this method can be used when analysing multiple simulation timepoints. Sets the scale of the timepoints being analysed, e.g. "Hours"}

\item{check_done}{If multiple timepoints, whether the input has been checked}
}
\description{
This takes each sample size to be examined in turn, and iterates through all
the subsets, determining the median and maximum A-Test score observed for
each sample size. A CSV file is created summarising the median and maximum
A-Test scores for all sample sizes, named as stated in parameter
SUMMARYFILENAME. If doing this analysis over multiple timepoints, the
timepoint will be appended to the filename given in SUMMARYFILENAME.
}
