% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ensemble_generation.R
\name{generate_ensemble_from_existing_emulations}
\alias{generate_ensemble_from_existing_emulations}
\title{Generate an ensemble from previously created spartan emulation objects}
\usage{
generate_ensemble_from_existing_emulations(existing_emulations, parameters,
  measures, observed_data, algorithm_settings = NULL, normalise = FALSE,
  timepoint = NULL)
}
\arguments{
\item{existing_emulations}{Vector of emulator objects created by method
\code{generate_requested_emulations}}

\item{parameters}{Array containing the names of the parameters for which
values are input into each emulation}

\item{measures}{Array containing the names of the output measures predicted
by each emulation}

\item{observed_data}{Dataset to train the new ensemble on. We recommend
using the test data in the set generated by partition_data method, and not
the training set, as the emulators themselves have been trained on that
data and the ensemble could thus overfit.}

\item{algorithm_settings}{Object output from the function
emulation_algorithm_settings, containing the settings of the machine
learning algorithms used in emulation creation. Here this is needed to
decide whether any accuracy plots should be produced during ensemble
creation, whether or not the ensemble should be saved to file, and to
specify the number of generations for which the neural network that is
generating the algorithm weightings should run.}

\item{normalise}{Whether the predictions generated when testing the
ensemble should be normalised for presenting test results}

\item{timepoint}{If using multiple timepoints, the timepoint for which
this ensemble is being created}
}
\value{
A list containing the ensemble, the time taken to generate it,
and the sampling mins and maxes used in its creation such that
unseen data used by and predictions generated by the ensemble can be
scaled and rescaled correctly
}
\description{
Where emulations have already been created, this method combines these to
form one ensemble. This takes as input a list of the emulator objects, the
simulation parameters and output response labels, and a set of test data
from which the performance weights will be evolved. We would recommend
providing the testing set of the output from the partition_dataset method.
An option is given, by setting these within emulation_algorithm_settings,
to save the ensemble object to file, as well as produce plots showing the
accuracy of the generated ensemble for the test data set
}
