% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lhc_analysis.R
\name{lhc_generateLHCSummary}
\alias{lhc_generateLHCSummary}
\title{Summarises simulation behaviour for each parameter set, by median of
distribution of replicate runs}
\usage{
lhc_generateLHCSummary(FILEPATH, PARAMETERS, MEASURES, LHC_ALL_SIM_RESULTS_FILE,
  LHCSUMMARYFILENAME, SPARTAN_PARAMETER_FILE = NULL, TIMEPOINTS = NULL,
  TIMEPOINTSCALE = NULL, check_done = FALSE)
}
\arguments{
\item{FILEPATH}{Directory where the simulation runs of single CSV file can
be found}

\item{PARAMETERS}{Array containing the names of the parameters of which
parameter samples will be generated}

\item{MEASURES}{Array containing the names of the output measures which are
used to analyse the simulation}

\item{LHC_ALL_SIM_RESULTS_FILE}{If lhc_process_sample_run_subsets is used
(i.e. results processed by folder structure), this will contain the output
of that method. If specifying responses using a single CSV file, this will
contain the name of that file (which should be in the FILEPATH folder).}

\item{LHCSUMMARYFILENAME}{Name of the LHC Summary file to be generated.
Contains each parameter set alongside the result gained when the simulation
was run under that criteria.}

\item{SPARTAN_PARAMETER_FILE}{Location of the file output by the
latin-hypercube sampling method (list of parameters). Note if providing a
single CSV file with parameter/response pairings, you do not need to provide
this file, and can thus enter this parameter as NULL.}

\item{TIMEPOINTS}{Implemented so this method can be used when analysing
multiple simulation timepoints. If only analysing one timepoint, this should
be set to NULL. If not, this should be an array of timepoints,
e.g. c(12,36,48,60)}

\item{TIMEPOINTSCALE}{Implemented so this method can be used when analysing
multiple simulation timepoints. Sets the scale of the timepoints being
analysed, e.g. "Hours"}

\item{check_done}{If using multiple timepoints, whether data entry has been
checked}
}
\description{
Processes either the CSV file generated by lhc_process_sample_run_subsets
or one that has been supplied, going through each line of that file and
generating a file that summarises simulation responses under each parameter
set. This CSV file, named as specified by parameter LHCSUMMARYFILENAME,
will contain one row for each parameter set, accompanied by the median of
all the responses contained in the LHC_ALL_SIM_RESULTS_FILE. This method
can also be performed for a number of simulation timepoints
}
