% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lhc_analysis.R
\name{lhc_generatePRCoEffs}
\alias{lhc_generatePRCoEffs}
\title{Generate Partial Rank Correlation Coefficients for parameter/response pairs}
\usage{
lhc_generatePRCoEffs(FILEPATH, PARAMETERS, MEASURES, LHCSUMMARYFILENAME,
  CORCOEFFSOUTPUTFILE, TIMEPOINTS = NULL, TIMEPOINTSCALE = NULL,
  cor_calc_method = c("s"), check_done = FALSE,
  write_csv_files = TRUE, lhc_summary_object = NULL)
}
\arguments{
\item{FILEPATH}{Directory where the simulation runs of single CSV file can
be found}

\item{PARAMETERS}{Array containing the names of the parameters of which
parameter samples will be generated}

\item{MEASURES}{Array containing the names of the output measures which are
used to analyse the simulation}

\item{LHCSUMMARYFILENAME}{Name of the LHC Summary file to be generated.
Contains each parameter set alongside the result gained when the simulation
was run under that criteria.}

\item{CORCOEFFSOUTPUTFILE}{Name of the generated CSV file generated}

\item{TIMEPOINTS}{Implemented so this method can be used when analysing
multiple simulation timepoints. If only analysing one timepoint, this should
be set to NULL. If not, this should be an array of timepoints,
e.g. c(12,36,48,60)}

\item{TIMEPOINTSCALE}{Implemented so this method can be used when analysing
multiple simulation timepoints. Sets the scale of the timepoints being
analysed, e.g. "Hours"}

\item{cor_calc_method}{Way to calculate the correlation coefficient: Pearson's
("p"), Spearman's ("s"), and Kendall's ("k"). Default is p}

\item{check_done}{If multiple timepoints, whether the input has been checked}

\item{write_csv_files}{Whether results should be output to CSV file. Used with spartanDB}

\item{lhc_summary_object}{If not specified in a CSV file, results can be specified in an
R object. In this case LHCSUMMARYFILENAME will be NULL}
}
\value{
If no CSV file output, PRCC values returned as an R object
}
\description{
For each parameter, and each simulation output measure, calculates the
Partial Rank Correlation Coefficient between the parameter value and the
simulation results, giving a statistical measurement of any effect that
is present.  This is output to a CSV file. Can be performed for a
number of timepoints if required.
}
