% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sim.bssr.1subgroup.r
\name{sim.bssr.1subgroup}
\alias{sim.bssr.1subgroup}
\title{Simulation of a One Subgroup Design with Internal Pilot Study}
\source{
\code{sim.bssr.1subgroup} uses code contributed by Marius Placzek.
}
\usage{
sim.bssr.1subgroup(nsim = 1000, alpha, beta, delta, sigma, tau, vdelta,
  vsigma, vtau, rec.at = 1/2, eps = 0.001, approx = c("conservative.t",
  "liberal.t", "normal"), df = c("n", "n1"), fix.tau = c("YES", "NO"),
  k = 1, adjust = c("YES", "NO"))
}
\arguments{
\item{nsim}{number of simulation runs.}

\item{alpha}{level (type I error) to which the hypothesis is tested.}

\item{beta}{type II error (power=1-beta) to which an alternative should be proven.}

\item{delta}{vector of true treatment effects, c(outside subgroup, inside subgroup).}

\item{sigma}{vector of true standard deviations, c(outside subgroup, inside subgroup).}

\item{tau}{subgroup prevalence.}

\item{vdelta}{vector of treatment effects to be proven, c(outside subgroup, inside subgroup).}

\item{vsigma}{vector of assumed standard deviations, c(outside subgroup, inside subgroup).}

\item{vtau}{expected subgroup prevalence.}

\item{rec.at}{blinded sample size review is performed after \code{rec.at}*\eqn{100\%} subjects of the initial sample size calculation.}

\item{eps}{precision parameter concerning the power calculation in the iterative sample size search algorithm.}

\item{approx}{approximation method: Use a conservative multivariate t distribution ("conservative.t"), a liberal multivariate t distribution ("liberal.t") or a multivariate normal distribution ("normal") to approximate the joint distribution of the standardized teststatistics.}

\item{df}{in case of a multivariate t distribution approximation, recalculate sample size with degrees of freedom depending on the size of the IPS (df=n1) or depending on the final sample size (df=n).}

\item{fix.tau}{subgroup prevalence is fixed by design (e.g. determined by recruitment) or is simulated and has to be reestimated during the blinded review.}

\item{k}{sample size allocation factor between groups: see 'Details'.}

\item{adjust}{adjust blinded estimators for assumed treatment effect ("YES","No").}
}
\value{
\code{sim.bssr.1subgroup} returns a data.frame containing the mean recalculated sample size within the control group and treatment group and the achieved simulated power along with all relevant parameters.
}
\description{
Given estimates of the treatment effects to be proven, the variances, and the prevalence,
\code{sim.bssr.1subgroup} calculates a initial sample size and performes a blinded sample size recalculation
after a prespecified number of subjects have been enrolled. Each oberservation is simulated and a final analysis executed.
Several variations are included, such as different approximations or sample size allocation.
}
\details{
This function combines sample size estimation, blinded sample size reestimation and analysis in a design with a subgroup within a full population where we want to test for treatment effects between a control and a treatment group.
The required sample size for the control and treatment group to prove an existing
alternative \code{delta} with a specified power 1-\code{beta} when testing the global null hypothesis \eqn{H_0: \Delta_F=\Delta_S=0} to level \code{alpha} is calculated prior to the study and then recalculated in an internal pilot study.

For sample sizes \eqn{n_C} and \eqn{n_T} of the control and treatment group, respectively, the argument \code{k} is the
sample size allocation factor, i.e. \eqn{k = n_T/n_C}.

The parameter \code{df} provides a difference to the standard sample size calculation procedure implemented in \code{\link{n.1subgroup}}.
When applying a multivariate t distribution approximation to approximate the joint distribution of the standardized test statistics it gives the opportunity to use degrees of freedom depending on the number of subjects in the IPS instead of degrees of freedom depending on the projected final sample size.
Note that this leads to better performance when dealing with extremely small subgroup sample sizes but significantly increases the calculated final sample size.
}
\examples{
sim.bssr.1subgroup(nsim=10,alpha=0.025,beta=0.1,delta=c(0,1),sigma=c(1,1.3),tau=0.2,
vdelta=c(0,1),vsigma=c(1,1),vtau=0.3,eps=0.002, approx="conservative.t",df="n",
fix.tau="YES",k=1,adjust="NO")

}
\seealso{
\code{sim.bssr.1subgroup} makes use of \code{\link{n.1subgroup}}, \code{\link{bssr.1subgroup}}, and \code{\link{r.1subgroup}}.
}
