% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gaussian.kernel.R
\name{gaussian.kernel}
\alias{gaussian.kernel}
\title{Gaussian Kernel}
\usage{
gaussian.kernel(sigma = 2, n = 5)
}
\arguments{
\item{sigma}{sigma (standard deviation) of kernel (defaults 2)}

\item{n}{size of symmetrical kernel (defaults to 5x5)}
}
\value{
matrix of gaussian distribution
}
\description{
Creates a Gaussian Kernel of specified size and sigma
}
\examples{
  par(mfrow=c(2,2))
  persp(gaussian.kernel(sigma=1, n=27), theta = 135, phi = 30, col = "grey", 
           ltheta = -120, shade = 0.6, border=NA )
  persp(gaussian.kernel(sigma=2, n=27), theta = 135, phi = 30, col = "grey", 
        ltheta = -120, shade = 0.6, border=NA )		
  persp(gaussian.kernel(sigma=3, n=27), theta = 135, phi = 30, col = "grey", 
        ltheta = -120, shade = 0.6, border=NA )				
  persp(gaussian.kernel(sigma=4, n=27), theta = 135, phi = 30, col = "grey", 
        ltheta = -120, shade = 0.6, border=NA )					
		
}
\references{
Riley, S.J., S.D. DeGloria and R. Elliot (1999) A terrain ruggedness index that quantifies topographic heterogeneity, Intermountain Journal of Sciences 5(1-4):23-27.
}
\author{
Jeffrey S. Evans  <jeffrey_evans@tnc.org>
}
