#' @name chen
#' @docType data
#'
#' @title Cross-correlation data from Chen (2015) 
#'
#' @description Urbanization and economic development data from Chen (2015)
#' compiled from, National Bureau of Statistics of China 
#'  \url{http://www.stats.gov.cn/tjsj/ndsj/}
#'
#' @format A list object with 3 elements:
#' \describe{
#'   \item{X}{per capita GRP(yuan)}
#'   \item{Y}{Level of urbanization percent}
#'   \item{M}{Railway Distance (km) matrix of 29 Chinese regions}
#' }
#'
#' @references
#' Chen, Y.G. (2012) On the four types of weight functions for spatial contiguity 
#'    matrix. Letters in Spatial and Resource Sciences 5(2):65-72 
#' @references
#' Chen, Y.G. (2013) New approaches for calculating Moran’s index of spatial 
#'   autocorrelation. PLoS ONE 8(7):e68336
#' @references 
#' Chen, Y.G. (2015) A New Methodology of Spatial Cross-Correlation Analysis. 
#'   PLoS One 10(5):e0126158. doi:10.1371/journal.pone.0126158
#'
#' @source \url{https://journals.plos.org/plosone/article?id=10.1371/journal.pone.0126158}
NULL