% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/optimized.sample.variance.R
\name{optimized.sample.variance}
\alias{optimized.sample.variance}
\title{Optimized sample variance}
\usage{
optimized.sample.variance(x, n, type = "maximized")
}
\arguments{
\item{x}{A vector to draw a sample from}

\item{n}{Number of samples to draw}

\item{type}{Type of sample variance optimization 
c("maximized", "minimized")}
}
\value{
A data.frame with "idx" representing the index of the original vector  
and "y" is the value of the sampled data
}
\description{
Draws an optimal sample that minimizes or maximizes the 
             sample variance
}
\examples{
library(sf)
data(meuse, package = "sp")
meuse <- st_as_sf(meuse, coords = c("x", "y"), crs = 28992, 
                  agr = "constant")

 n = 15
 # Draw n samples that maximize the variance of y
 ( max.sv <- optimized.sample.variance(meuse$zinc, 15) )
 
 # Draw n samples that minimize the variance of y
 ( min.sv <- optimized.sample.variance(meuse$zinc, 15, 
               type="minimized") )
 
 # Plot results
 plot(st_geometry(meuse), pch=19, col="grey")
   plot(st_geometry(meuse[max.sv$idx,]), col="red", add=TRUE, pch=19)
     plot(st_geometry(meuse[min.sv$idx,]), col="blue", add=TRUE, pch=19)
 	  box()
     legend("topleft", legend=c("population","maximized variance", 
            "minimized variance"), col=c("grey","red","blue"),  
            pch=c(19,19,19))  
 
}
\author{
Jeffrey S. Evans  <jeffrey_evans@tnc.org>
}
