% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/insert.values.R
\name{insert.values}
\alias{insert.values}
\title{Insert Values}
\usage{
insert.values(x, value, index)
}
\arguments{
\item{x}{A vector to insert values}

\item{value}{Values to insert into x}

\item{index}{Index position(s) to insert y values into x}
}
\value{
A vector with values of y inserted into x and the position(s) 
defined by the index
}
\description{
Inserts new values into a vector at 
             specified positions
}
\details{
This function inserts new values at specified positions in a vector. It 
does not replace existing values. If a single value is provided for y 
and l represents multiple positions y will be replicated for the length 
of l. In this way you can insert the same value at multiple locations.
}
\examples{
(x=1:10)

 # Insert single value in one location
 insert.values(x, 100, 2) 

 # Insert multiple values in multiple locations 
 insert.values(x, c(100,200), c(2,8)) 

 # Insert single value in multiple locations 
 insert.values(x, NA, c(2,8))

}
\author{
Jeffrey S. Evans <jeffrey_evans@tnc.org>
}
