% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/create_mif.R
\name{create_mif}
\alias{create_mif}
\title{Create Multiplex Immunoflourescent object}
\usage{
create_mif(
  clinical_data,
  sample_data,
  spatial_list = NULL,
  patient_id = "patient_id",
  sample_id = "image_tag",
  clean_columns = FALSE
)
}
\arguments{
\item{clinical_data}{A data frame containing patient level data with one row
per participant.}

\item{sample_data}{A data frame containing sample level data with one row per
sample. Should at a minimum contain a 2 columns: one for sample names and
one for the corresponding patient name.}

\item{spatial_list}{A named list of data frames with the spatial data from
each sample making up each individual data frame}

\item{patient_id}{A character string indicating the column name for patient id in
sample and clinical data frames.}

\item{sample_id}{A character string indicating the column name for sample id
in the sample data frame}

\item{clean_columns}{A logical value indicating if names in spatial data frames
should be rewritten in a cleaner format. Default is FALSE.}
}
\value{
Returns a custom MIF
\item{clinical}{Data frame of clinical data}
\item{sample}{Data frame of sample data}
\item{spatial}{Named list of spatial data}
\item{derived}{List of data derived using the MIF object}
}
\description{
Creates an MIF object for use in spatialIF functions
}
