% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/indictest.R
\name{indictest}
\alias{indictest}
\title{Significance-assessment of spatial early-warning signals}
\usage{
indictest(x, nperm = 999, ...)
}
\arguments{
\item{x}{A spatial warning object such as one produced by the \code{*_sews} 
function family}

\item{nperm}{The number of permutations to carry out to produce the null 
distribution}

\item{...}{Additional arguments passed to methods}
}
\value{
An object of class \code{*_sews_test} depending on the input object
  (actually, a data.frame)
}
\description{
Assess the significance of spatial early-warning values
}
\details{
The significance of many early-warning signals can be estimated by 
  reshuffling the original matrix. Indicators are then recomputed 
  on the shuffled matrices and the values obtained are used as a null 
  distribution. P-values are obtained based on the rank of the observered
  value in the null distribution.
}
\references{
Kefi, S., Guttal, V., Brock, W.A., Carpenter, S.R., Ellison, A.M., Livina, 
  V.N., et al. (2014). Early Warning Signals of Ecological Transitions: 
  Methods for Spatial Patterns. PLoS ONE, 9, e92097
}
\seealso{
\code{\link{generic_sews}}, \code{\link{spectral_sews}}
}
