\name{lpp}
\alias{lpp}
\title{
  Create Point Pattern on Linear Network
}
\description{
  Creates an object of class \code{"lpp"} that represents
  a point pattern on a linear network.
}
\usage{
lpp(X, L)
}
\arguments{
  \item{X}{
    Locations of the points. A matrix or data frame of coordinates,
    or a point pattern object (of class
    \code{"ppp"}) or other data acceptable to \code{\link{as.ppp}}.
  }
  \item{L}{
    Linear network (object of class \code{"linnet"}).
}
}
\details{
  This command creates an object of class \code{"lpp"} that represents
  a point pattern on a linear network. The points of \code{X} should lie
  on the lines of \code{L}. 
}
\value{
  An object of class \code{"lpp"}. 
  Also inherits the class \code{"ppx"}.
}
\author{
  Ang Qi Wei \email{aqw07398@hotmail.com} and
  Adrian Baddeley \email{Adrian.Baddeley@csiro.au}
  \url{http://www.maths.uwa.edu.au/~adrian/}
}
\seealso{
  \code{\link[spatstat:methods.lpp]{methods.lpp}} and
  \code{\link[spatstat:methods.ppx]{methods.ppx}} for methods applicable
  to \code{lpp} objects.
  
  \code{\link{linnet}} for linear networks.

  Random point patterns on a linear network can be generated by
  \code{\link{rpoislpp}} or \code{\link{runiflpp}}.
}
\examples{
  example(linnet)
  xx <- list(x=c(-1.5,0,0.5,1.5), y=c(1.5,3,4.5,1.5))
  X <- lpp(xx, letterA)
  plot(X)
  X
  summary(X)
}
\keyword{spatial}
