% Generated by roxygen2 (4.0.1): do not edit by hand
\name{BsplineHaz}
\alias{BsplineHaz}
\title{BsplineHaz function}
\usage{
BsplineHaz(times, knots = quantile(times), degree = 3, MLinits = NULL)
}
\arguments{
\item{times}{vector of survival times (both censored and uncensored)}

\item{knots}{vector of knots in ascending order, must include minimum and maximum values of 'times'}

\item{degree}{degree of the spline basis, default is 3}

\item{MLinits}{optional starting values for the non-spatial maximisation routine using optim. Note that we are working with the log of the parameters. Default is -10 for each parameter.}
}
\value{
an object inheriting class 'basehazardspec'
}
\description{
A function to define a parametric proportional hazards model where the baseline hazard is modelled by a basis spline.
This function returns an object inheriting class 'basehazardspec', list of functions 'distinfo', 'basehazard', 'gradbasehazard', 'hessbasehazard',
'cumbasehazard', 'gradcumbasehazard', 'hesscumbasehazard' and 'densityquantile'
}
\details{
The \code{distinfo} function is used to provide basic distribution specific information to other \code{spatsurv} functions. The user is required
to provide the following information in the returned list: \code{npars}, the number of parameters in this distribution; \code{parnames},
the names of the parameters; \code{trans}, the transformation scale on which the priors will be provided; \code{itrans}, the inverse
transformation function that will be applied to the parameters before the hazard, and other functions are evaluated; \code{jacobian},
the derivative of the inverse transformation function with respect to each of the parameters; and \code{hessian}, the second derivatives
of the inverse transformation function with respect to each of the parameters -- note that currently the package \code{spatsurv}
only allows the use of functions where the parameters are transformed independently.

The \code{basehazard} function is used to evaluate the baseline hazard function for the distribution of interest. It returns a
function that accepts as input a vector of times, \code{t} and returns a vector.

The \code{gradbasehazard} function is used to evaluate the gradient of the baseline hazard function with respect to the parameters,
this typically returns a vector. It returns a function that accepts as input a vector of times, \code{t}, and returns a matrix.

The \code{hessbasehazard} function is used to evaluate the Hessian of the baseline hazard function. It returns a function that accepts
as input a vector of times, \code{t} and returns a list of hessian matrices corresponding to each \code{t}.

The \code{cumbasehazard} function is used to evaluate the cumulative baseline hazard function for the distribution of interest.
It returns a function that accepts as input a vector of times, \code{t} and returns a vector.

The \code{gradcumbasehazard} function is used to evaluate the gradient of the cumulative baseline hazard function with respect
to the parameters, this typically returns a vector. It returns a function that accepts as input a vector of times, \code{t}, and returns a matrix.

The \code{hesscumbasehazard} function is used to evaluate the Hessian of the cumulative baseline hazard function. It returns a
function that accepts as input a vector of times, \code{t} and returns a list of hessian matrices corresponding to each \code{t}.

The \code{densityquantile} function is used to return quantiles of the density function. This is NOT REQUIRED for running the MCMC,
merely for us in post-processing with the \code{predict} function where \code{type} is 'densityquantile'. In the case of the Weibull
model for the baseline hazard, it can be shown that the q-th quantile is:
}
\seealso{
\link{exponentialHaz}, \link{gompertzHaz}, \link{makehamHaz}, \link{weibullHaz}
}

