% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ValidatePanelDesign.R
\name{ValidatePanelDesign}
\alias{ValidatePanelDesign}
\title{Validate the panels and panel_overlap parameters.}
\usage{
ValidatePanelDesign(panels, panel_overlap, n)
}
\arguments{
\item{panels}{A list of integers that define the size of each panel in a
non-overlapping panels design. The length of the list determines the number of
panels required. The sum of the integers in the panels parameter will determine
the total number of samples selected, n. The default value for panels is NULL,
this indicates that a non-overlapping panel design is not wanted.}

\item{panel_overlap}{A list of integers that define the overlap into the previous
panel. It is only used when the panels parameter is not NULL. The default value for
panel_overlap is NULL. The length of panel_overlap must be equal to the length
of panels. The first value is always forced to zero as the first panel never
overlaps any region.}

\item{n}{The number of samples required. Only used when panels and panel_overlap are NULL.}
}
\value{
A list containing four variables, they are detailed below.

\itemize{
\item \code{n} When the \code{panels} parameter is not null, the \code{n} parameter is set
using the sum of all the panel sizes in \code{panels}.
\item \code{panel_design} A boolean, TRUE, indicates that the user wants a panels design.
\item \code{number_panels} The number of panels specified in the panel design.
\item \code{panel_overlap} Updated panel_overlap vector, the first element is always forced
to zero irrespective of what the user specified.
}
}
\description{
This function is used to validate the panels and panel_overlap
parameters. The panel_design flag is set TRUE when the panels and/or panel_overlap
parameters are not NULL. This is an internal only function.
}
\author{
Phil Davies.
}
\keyword{internal}
