% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getHaltonPointsFromExpandableGrid.R
\name{getHaltonPointsFromExpandableGrid}
\alias{getHaltonPointsFromExpandableGrid}
\title{Generate a Halton frame.}
\usage{
getHaltonPointsFromExpandableGrid(
  shapefile,
  N,
  J = base::c(4, 3),
  bases,
  seeds,
  crs,
  verbose = FALSE,
  stratify_found_first = FALSE
)
}
\arguments{
\item{shapefile}{Shape file as a polygon (sp or sf) of the study area(s).}

\item{N}{Number of sites to select. If using stratification it is a named vector containing
sample sizes of each group.}

\item{J}{The number of grid cells. A list of 2 values. The default value is c(3, 2).}

\item{bases}{Co-prime base for the Halton Sequence. The default value is c(2, 3).}

\item{seeds}{A vector of 2 seeds, u1 and u2.}

\item{crs}{Coordinate reference system for the shapefile.}

\item{verbose}{Boolean if you want to see any output printed to screen. Helpful if taking a
long time. Default is FALSE i.e. no informational messages are displayed.}

\item{stratify_found_first}{A flag to indicate whether we have found the first point in the
study region or not. Default FALSE.}
}
\value{
A list containing five variables:

\itemize{
\item \code{i} The index of the first point chosen at random in the study area.
\item \code{diff_} Halton points, the intersection of the bounding box and the study area.
\item \code{pts.shp} Halton frame, the sample points within the study area.
\item \code{bb.new} The bounding box.
\item \code{seeds} The u1 and u2 seeds used to generate the sample.
}
}
\description{
Find the requested number of Halton points from within a study area using the
supplied J and seeds parameters. If the number of points are not found on the first attempt,
the frame is expanded, and spbal::getHaltonFrame is called again. This process is repeated
until the requested number of points are found. The points and the seeds used to generate
the sample are returned to the caller.
}
\author{
Phil Davies.
}
\keyword{internal}
