% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Spectra-methods.R, R/SpectraDataFrame-methods.R
\docType{methods}
\name{melt_spectra}
\alias{melt_spectra}
\alias{melt_spectra-methods}
\alias{melt_spectra,Spectra-method}
\alias{melt_spectra,SpectraDataFrame-method}
\title{Melts the spectra data of a Spectra object and returns it as wide format.}
\usage{
melt_spectra(obj, attr=NULL, ...)

\S4method{melt_spectra}{SpectraDataFrame}(obj, attr = NULL, ...)
}
\arguments{
\item{obj}{an object of class \code{"Spectra"} or inheriting from this class}

\item{attr}{vector of id variables against which the spectra will be melted (see \code{melt})}

\item{...}{further arguments passed to or from other methods}
}
\description{
This function is very useful when wanting to plot spectra using the lattice or ggplot2 packages
}
\section{Methods}{
 \describe{

\bold{x=Spectra}

\code{melt_spectra(obj, ...)}

\tabular{rll}{ \tab \code{obj} \tab A \code{Spectra} object \cr \tab
\code{...} \tab Ignored \cr }

\bold{x=SpectraDataFrame}

\code{melt_spectra(obj, attr=NULL, ...)}

\tabular{rll}{ \tab \code{obj} \tab A \code{SpectraDataFrame} object \cr
\tab \code{attr} \tab Character, the name of an attribute in the object data
to split the spectra against. \cr \tab \code{...} \tab Ignored \cr }

}
}

\examples{

# Loading example data
data(australia)
spectra(australia) <- sr_no ~ ... ~ 350:2500

# Simple melt
r <- melt_spectra(australia)
head(r)

\dontrun{
# Melt against some factor (or continuous data), and plot
# using ggplot2

# Create some factor
australia$fact <- sample(
  LETTERS[1:3], 
  size = nrow(australia), 
  replace = TRUE
)
r <- melt_spectra(australia, attr = 'fact')

# Create plot
library(ggplot2)
p <- ggplot(r) + 
  geom_line(aes(x=wl, y=nir, group=id, colour=fact)) + 
  theme_bw()
print(p)
}

}
\references{
Hadley Wickham (2011). The Split-Apply-Combine Strategy for Data
Analysis. Journal of Statistical Software, 40(1), 1-29. URL
http://www.jstatsoft.org/v40/i01/.
}
\author{
Pierre Roudier \email{pierre.roudier@gmail.com}
}
