% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GetSatellite.R
\name{GetSatellite}
\alias{GetSatellite}
\title{Gets info for a satellite}
\source{
\url{https://api.spectator.earth/#satellites}
}
\usage{
GetSatellite(satellite, positions = TRUE)
}
\arguments{
\item{satellite}{character name of the satellite for which to retrieve the trajectory.
The satellite name is not case sensitive, and can be abbreviated as long as an unambiguous match can be obtained.
Only one satellite can be queried at a time.}

\item{positions}{logical indicating if the current position should be included. Default: TRUE}
}
\value{
If \code{positions} is \code{FALSE}, a single row data frame with following attributes:
\describe{
\item{\code{id}}{integer identifier}
\item{\code{name}}{character satellite name}
\item{\code{norad_id}}{integer satellite catalog number}
\item{\code{sensors}}{character type of sensors available on the satellite (SAR or Optical)}
\item{\code{open}}{logical whether the data produced by the satellite is freely accessible}
\item{\code{platform}}{character platform name}
}
If \code{positions} is \code{TRUE}, a single row object of class '\code{sf}' with '\code{POINT}' geometry type,
with the same attributes as above.
}
\description{
Gets the information about the specified satellite, and possibly its current position.
}
\examples{
if(interactive()){
 library(sf)
 # get trajectory and current position for a selected satellite
 sat <- "SPOT-7"
 traj <- GetTrajectory(satellite = sat)
 pos <- GetSatellite(satellite = sat, positions = TRUE)
 # do some nice graphs
 library(maps)
 map("world", fill = TRUE, col = "lightgrey")
 plot(st_geometry(traj), lwd = 2, col = "red", add = TRUE)
 plot(st_geometry(pos), pch = 15, col = "green", cex = 1.5, add = TRUE)
 title(main = sprintf("current \%s trajectory & position", sat))
 }
}
\seealso{
\code{\link[spectator]{GetAllSatellites}}
}
