% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/conversion.R
\name{as.data.frame.spectra}
\alias{as.data.frame.spectra}
\title{Convert spectra to data.frame}
\usage{
\method{as.data.frame}{spectra}(
  x,
  row.names = NULL,
  optional = FALSE,
  fix_names = "none",
  metadata = TRUE,
  ...
)
}
\arguments{
\item{x}{spectra object}

\item{row.names}{does nothing. Here for compatibility with S3 generics}

\item{optional}{does nothing. Here for compatibility with S3 generics}

\item{fix_names}{Use make.names to normalize names?
Pick one: "none" "row" "col" "both".}

\item{metadata}{boolean. Include spectral metadata? Defaults to TRUE}

\item{...}{extra parameters passed to the generic as.spectra}
}
\value{
data.frame with: sample_name, metadata (if any) and value.
}
\description{
Returns a data.frame that includes sample names, metadata (if present) and
value data. One advantage over as.matrix, is that the metadata are
returned.
}
\examples{
library(spectrolab)
spec = as.spectra(spec_matrix_example, name_idx = 1)
df   = as.data.frame(spec, fix_names = "none")
}
\author{
Jose Eduardo Meireles
}
