/*
 * Decompiled with CFR 0.152.
 */
package at.ac.ait.speedr.table.model.twodim;

import at.ac.ait.speedr.table.RDate;
import at.ac.ait.speedr.table.RPOSIXct;
import at.ac.ait.speedr.table.model.RAbstractTableModel;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.rosuda.REngine.REXPDouble;
import org.rosuda.REngine.REXPFactor;
import org.rosuda.REngine.REXPGenericVector;
import org.rosuda.REngine.REXPInteger;
import org.rosuda.REngine.REXPLogical;
import org.rosuda.REngine.REXPMismatchException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RDataFrameTableModel
extends RAbstractTableModel {
    private REXPGenericVector data;
    private String[] rownames;
    private String[] colnames;
    private Class[] colClasses;

    public RDataFrameTableModel(REXPGenericVector data) throws REXPMismatchException {
        this.data = data;
        this.rownames = data.getAttribute("row.names").asStrings();
        this.colnames = data.getAttribute("names").asStrings();
    }

    @Override
    public int getRowCount() {
        return this.rownames.length;
    }

    @Override
    public int getColumnCount() {
        return this.colnames.length + 1;
    }

    @Override
    public Class<?> getColumnClass(int columnIndex) {
        if (this.colClasses == null) {
            this.initColClasses();
        }
        if (columnIndex == 0) {
            return String.class;
        }
        return this.colClasses[--columnIndex];
    }

    private void initColClasses() {
        this.colClasses = new Class[this.data.asList().size()];
        for (int i = 0; i < this.colClasses.length; ++i) {
            try {
                if (this.data.asList().at(i).hasAttribute("class") && this.data.asList().at(i).getAttribute("class").asString().equals("Date")) {
                    this.colClasses[i] = RDate.class;
                    continue;
                }
                if (this.data.asList().at(i).hasAttribute("class") && this.data.asList().at(i).getAttribute("class").asString().equals("POSIXct")) {
                    this.colClasses[i] = RPOSIXct.class;
                    continue;
                }
            }
            catch (REXPMismatchException ex) {
                Logger.getLogger(RDataFrameTableModel.class.getName()).log(Level.SEVERE, null, ex);
            }
            if (this.data.asList().at(i).isFactor()) {
                this.colClasses[i] = REXPFactor.class;
                continue;
            }
            if (this.data.asList().at(i).isNumeric()) {
                if (this.data.asList().at(i).isInteger()) {
                    this.colClasses[i] = REXPInteger.class;
                    continue;
                }
                this.colClasses[i] = REXPDouble.class;
                continue;
            }
            this.colClasses[i] = this.data.asList().at(i).isString() ? String.class : (this.data.asList().at(i).isLogical() ? Boolean.class : super.getColumnClass(i));
        }
    }

    @Override
    public String getColumnName(int column) {
        if (column == 0) {
            return "row.names";
        }
        return this.colnames[column - 1];
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        if (columnIndex == 0) {
            return this.rownames[rowIndex];
        }
        --columnIndex;
        try {
            if (this.colClasses[columnIndex] == RDate.class) {
                return new RDate((long)this.data.asList().at(columnIndex).asDoubles()[rowIndex]);
            }
            if (this.colClasses[columnIndex] == RPOSIXct.class) {
                return new RPOSIXct((long)this.data.asList().at(columnIndex).asDoubles()[rowIndex]);
            }
            if (this.colClasses[columnIndex] == Boolean.class) {
                if (REXPLogical.isNA((byte)this.data.asList().at(columnIndex).asBytes()[columnIndex])) {
                    return null;
                }
                return this.data.asList().at(columnIndex).asBytes()[columnIndex] == 1;
            }
            if (this.colClasses[columnIndex] == REXPFactor.class) {
                return this.data.asList().at(columnIndex).asFactor().at(rowIndex);
            }
            if (this.colClasses[columnIndex] == REXPInteger.class) {
                if (REXPInteger.isNA((int)this.data.asList().at(columnIndex).asIntegers()[rowIndex])) {
                    return null;
                }
                return this.data.asList().at(columnIndex).asIntegers()[rowIndex];
            }
            if (this.colClasses[columnIndex] == REXPDouble.class) {
                if (REXPDouble.isNA((double)this.data.asList().at(columnIndex).asDoubles()[rowIndex])) {
                    return null;
                }
                return this.data.asList().at(columnIndex).asDoubles()[rowIndex];
            }
            if (this.colClasses[columnIndex] == String.class) {
                return this.data.asList().at(columnIndex).asStrings()[rowIndex];
            }
            Logger.getLogger(RDataFrameTableModel.class.getName()).log(Level.WARNING, "Unknown column class type: {0}", this.getColumnClass(columnIndex));
            return "Error: null";
        }
        catch (REXPMismatchException ex) {
            Logger.getLogger(RDataFrameTableModel.class.getName()).log(Level.WARNING, null, ex);
            return "Error: exception";
        }
    }

    @Override
    public String getColumnIndexCode(int columnIndex) {
        return "[[\"" + this.getColumnName(columnIndex) + "\"]]";
    }

    @Override
    public String getRownameIndexCode(String var) {
        return "rownames(" + var + ")";
    }
}

