/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.common.intern;

import bibliothek.gui.dock.facile.mode.Location;
import bibliothek.gui.dock.frontend.Setting;
import bibliothek.gui.dock.layout.DockSituation;
import bibliothek.gui.dock.layout.PropertyTransformer;
import bibliothek.gui.dock.support.mode.ModeSettings;
import bibliothek.util.Version;
import bibliothek.util.xml.XElement;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CSetting
extends Setting {
    private ModeSettings<Location, ?> modes;
    private Map<String, List<String>> multiFactoryDockables = new HashMap<String, List<String>>();

    public void setModes(ModeSettings<Location, ?> modeSettings) {
        this.modes = modeSettings;
    }

    public ModeSettings<Location, ?> getModes() {
        return this.modes;
    }

    public void putMultipleFactoryDockables(String string, List<String> list) {
        if (list == null) {
            throw new IllegalArgumentException("dockables must not be null");
        }
        this.multiFactoryDockables.put(string, list);
    }

    public List<String> getMultipleFactoryDockables(String string) {
        return this.multiFactoryDockables.get(string);
    }

    @Override
    public void write(DockSituation dockSituation, PropertyTransformer propertyTransformer, boolean bl, DataOutputStream dataOutputStream) throws IOException {
        Version.write(dataOutputStream, Version.VERSION_1_0_8);
        super.write(dockSituation, propertyTransformer, bl, dataOutputStream);
        this.modes.write(dataOutputStream);
        dataOutputStream.writeInt(this.multiFactoryDockables.size());
        for (Map.Entry<String, List<String>> entry : this.multiFactoryDockables.entrySet()) {
            dataOutputStream.writeUTF(entry.getKey());
            List<String> list = entry.getValue();
            dataOutputStream.writeInt(list.size());
            for (String string : list) {
                dataOutputStream.writeUTF(string);
            }
        }
    }

    @Override
    public void writeXML(DockSituation dockSituation, PropertyTransformer propertyTransformer, boolean bl, XElement xElement) {
        super.writeXML(dockSituation, propertyTransformer, bl, xElement.addElement("base"));
        this.modes.writeXML(xElement.addElement("modes"));
        if (!this.multiFactoryDockables.isEmpty()) {
            XElement xElement2 = xElement.addElement("multi-factories");
            for (Map.Entry<String, List<String>> entry : this.multiFactoryDockables.entrySet()) {
                XElement xElement3 = xElement2.addElement("factory");
                xElement3.addString("id", entry.getKey());
                for (String string : entry.getValue()) {
                    xElement3.addElement("dockable").addString("id", string);
                }
            }
        }
    }

    @Override
    public void read(DockSituation dockSituation, PropertyTransformer propertyTransformer, boolean bl, DataInputStream dataInputStream) throws IOException {
        Version version = Version.read(dataInputStream);
        version.checkCurrent();
        boolean bl2 = version.compareTo(Version.VERSION_1_0_7) >= 0;
        super.read(dockSituation, propertyTransformer, bl, dataInputStream);
        this.modes.read(dataInputStream);
        if (bl2) {
            int n = dataInputStream.readInt();
            for (int i = 0; i < n; ++i) {
                String string = dataInputStream.readUTF();
                ArrayList<String> arrayList = new ArrayList<String>();
                int n2 = dataInputStream.readInt();
                for (int j = 0; j < n2; ++j) {
                    arrayList.add(dataInputStream.readUTF());
                }
                this.putMultipleFactoryDockables(string, arrayList);
            }
        }
    }

    @Override
    public void readXML(DockSituation dockSituation, PropertyTransformer propertyTransformer, boolean bl, XElement xElement) {
        super.readXML(dockSituation, propertyTransformer, bl, xElement.getElement("base"));
        this.modes.readXML(xElement.getElement("modes"));
        XElement xElement2 = xElement.getElement("multi-factories");
        if (xElement2 != null) {
            for (XElement xElement3 : xElement2.getElements("factory")) {
                ArrayList<String> arrayList = new ArrayList<String>();
                for (XElement xElement4 : xElement3.getElements("dockable")) {
                    String string = xElement4.getString("id");
                    if (string == null) continue;
                    arrayList.add(string);
                }
                String object = xElement3.getString("id");
                if (object == null) continue;
                this.putMultipleFactoryDockables(object, arrayList);
            }
        }
    }
}

