/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.common.intern.color;

import bibliothek.gui.dock.common.intern.color.TabColorTransmitter;
import bibliothek.gui.dock.themes.ColorBridgeFactory;
import bibliothek.gui.dock.util.color.ColorManager;
import bibliothek.util.Colors;
import java.awt.Color;

public class EclipseTabTransmitter
extends TabColorTransmitter {
    public static final ColorBridgeFactory FACTORY = new ColorBridgeFactory(){

        public EclipseTabTransmitter create(ColorManager colorManager) {
            return new EclipseTabTransmitter(colorManager);
        }
    };
    private static final String[] KEYS = new String[]{"stack.tab.border", "stack.tab.border.selected", "stack.tab.border.selected.focused", "stack.tab.border.selected.focuslost", "stack.tab.top", "stack.tab.top.selected", "stack.tab.top.selected.focused", "stack.tab.top.selected.focuslost", "stack.tab.bottom", "stack.tab.bottom.selected", "stack.tab.bottom.selected.focused", "stack.tab.bottom.selected.focuslost", "stack.tab.text", "stack.tab.text.selected", "stack.tab.text.selected.focused", "stack.tab.text.selected.focuslost"};

    public EclipseTabTransmitter(ColorManager colorManager) {
        super(colorManager, KEYS);
    }

    protected boolean isFocused(String string) {
        return string.contains("focused") || string.contains("focuslost");
    }

    protected boolean isSelected(String string) {
        return string.contains("selected");
    }

    protected boolean isForeground(String string) {
        return string.contains("text");
    }

    protected Color convert(Color color, String string) {
        if (this.isSelected(string)) {
            return this.convertSelected(color, string);
        }
        if (this.isFocused(string)) {
            return this.convertFocused(color, string);
        }
        if ("stack.tab.border".equals(string)) {
            return color;
        }
        if ("stack.tab.top".equals(string)) {
            return Colors.undiffMirror(color, 0.5);
        }
        if ("stack.tab.bottom".equals(string)) {
            return color;
        }
        if ("stack.tab.text".equals(string)) {
            return Colors.diffMirror(color, 1.0);
        }
        return null;
    }

    protected Color convertSelected(Color color, String string) {
        if (this.isFocused(string)) {
            return this.convertFocused(color, string);
        }
        if ("stack.tab.border.selected".equals(string)) {
            return color;
        }
        if ("stack.tab.top.selected".equals(string)) {
            return Colors.undiffMirror(color, 0.5);
        }
        if ("stack.tab.bottom.selected".equals(string)) {
            return color;
        }
        if ("stack.tab.text.selected".equals(string)) {
            return Colors.diffMirror(color, 1.0);
        }
        return null;
    }

    protected Color convertFocused(Color color, String string) {
        if ("stack.tab.border.selected.focused".equals(string)) {
            return color;
        }
        if ("stack.tab.border.selected.focuslost".equals(string)) {
            return color;
        }
        if ("stack.tab.top.selected.focused".equals(string)) {
            return Colors.undiffMirror(color, 0.5);
        }
        if ("stack.tab.top.selected.focuslost".equals(string)) {
            return Colors.undiffMirror(color, 0.5);
        }
        if ("stack.tab.bottom.selected.focused".equals(string)) {
            return color;
        }
        if ("stack.tab.bottom.selected.focuslost".equals(string)) {
            return color;
        }
        if ("stack.tab.text.selected.focused".equals(string)) {
            return Colors.diffMirror(color, 1.0);
        }
        if ("stack.tab.text.selected.focuslost".equals(string)) {
            return Colors.diffMirror(color, 1.0);
        }
        return null;
    }
}

