/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.support.menu;

import bibliothek.gui.dock.support.menu.MenuPieceListener;
import java.awt.Component;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import javax.swing.JMenu;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class MenuPiece {
    private MenuPiece parent;
    private List<MenuPieceListener> listeners = new ArrayList<MenuPieceListener>();

    public void addListener(MenuPieceListener menuPieceListener) {
        this.listeners.add(menuPieceListener);
    }

    public void removeListener(MenuPieceListener menuPieceListener) {
        this.listeners.remove(menuPieceListener);
    }

    protected void fireInsert(int n, Component ... componentArray) {
        for (MenuPieceListener menuPieceListener : this.listeners.toArray(new MenuPieceListener[this.listeners.size()])) {
            menuPieceListener.insert(this, n, componentArray);
        }
    }

    protected void fireRemove(int n, int n2) {
        for (MenuPieceListener menuPieceListener : this.listeners.toArray(new MenuPieceListener[this.listeners.size()])) {
            menuPieceListener.remove(this, n, n2);
        }
    }

    public JMenu getMenu() {
        if (this.parent == null) {
            return null;
        }
        return this.parent.getMenu();
    }

    public MenuPiece getParent() {
        return this.parent;
    }

    public void setParent(MenuPiece menuPiece) {
        this.parent = menuPiece;
    }

    public abstract int getItemCount();

    public abstract void fill(List<Component> var1);

    public Component[] items() {
        LinkedList<Component> linkedList = new LinkedList<Component>();
        this.fill(linkedList);
        return linkedList.toArray(new Component[linkedList.size()]);
    }
}

