/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.extension.gui.dock.theme.smooth;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Timer;

public abstract class SmoothChanger
implements ActionListener {
    private long last;
    private int[] current;
    private int duration;
    private Timer timer;

    public SmoothChanger(int n) {
        this(250, n);
    }

    public SmoothChanger(int n, int n2) {
        this.duration = n;
        this.timer = new Timer(15, this);
        this.current = new int[n2];
    }

    protected abstract int destination();

    protected abstract void repaint(int[] var1);

    public void setDuration(int n) {
        if (n < 1) {
            throw new IllegalArgumentException("duration must be >= 1");
        }
        this.duration = n;
        for (int i = 0; i < this.current.length; ++i) {
            this.current[i] = Math.min(this.current[i], n);
        }
        this.repaint(this.current);
    }

    public boolean isRunning() {
        return this.timer.isRunning();
    }

    public int getDuration() {
        return this.duration;
    }

    public void trigger() {
        this.timer.start();
        this.last = System.currentTimeMillis();
    }

    public void actionPerformed(ActionEvent actionEvent) {
        long l = System.currentTimeMillis();
        int n = (int)(l - this.last);
        this.last = l;
        int n2 = this.destination();
        boolean bl = false;
        for (int i = 0; i < this.current.length; ++i) {
            if (i == n2) {
                this.current[i] = Math.min(this.current[i] + n, this.duration);
                bl = bl || this.current[i] < this.duration;
                continue;
            }
            this.current[i] = Math.max(this.current[i] - n, 0);
            bl = bl || this.current[i] > 0;
        }
        if (!bl) {
            this.timer.stop();
        }
        this.repaint(this.current);
    }
}

