/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock;

import bibliothek.gui.DockController;
import bibliothek.gui.DockStation;
import bibliothek.gui.DockTheme;
import bibliothek.gui.DockUI;
import bibliothek.gui.Dockable;
import bibliothek.gui.dock.displayer.DockableDisplayerHints;
import bibliothek.gui.dock.event.DockStationAdapter;
import bibliothek.gui.dock.event.DockableListener;
import bibliothek.gui.dock.layout.DockableProperty;
import bibliothek.gui.dock.station.AbstractDockableStation;
import bibliothek.gui.dock.station.DisplayerCollection;
import bibliothek.gui.dock.station.DockableDisplayer;
import bibliothek.gui.dock.station.DockableDisplayerListener;
import bibliothek.gui.dock.station.OverpaintablePanel;
import bibliothek.gui.dock.station.StationChildHandle;
import bibliothek.gui.dock.station.stack.DefaultStackDockComponent;
import bibliothek.gui.dock.station.stack.StackDockComponent;
import bibliothek.gui.dock.station.stack.StackDockComponentFactory;
import bibliothek.gui.dock.station.stack.StackDockComponentParent;
import bibliothek.gui.dock.station.stack.StackDockComponentRepresentative;
import bibliothek.gui.dock.station.stack.StackDockProperty;
import bibliothek.gui.dock.station.stack.StackDockStationFactory;
import bibliothek.gui.dock.station.stack.TabContent;
import bibliothek.gui.dock.station.stack.TabContentFilterListener;
import bibliothek.gui.dock.station.stack.tab.TabContentFilter;
import bibliothek.gui.dock.station.stack.tab.layouting.TabPlacement;
import bibliothek.gui.dock.station.support.ConvertedPlaceholderListItem;
import bibliothek.gui.dock.station.support.DisplayerFactoryWrapper;
import bibliothek.gui.dock.station.support.DockableVisibilityManager;
import bibliothek.gui.dock.station.support.PlaceholderList;
import bibliothek.gui.dock.station.support.PlaceholderListItemAdapter;
import bibliothek.gui.dock.station.support.PlaceholderListItemConverter;
import bibliothek.gui.dock.station.support.PlaceholderMap;
import bibliothek.gui.dock.station.support.PlaceholderStrategy;
import bibliothek.gui.dock.station.support.StationPaintWrapper;
import bibliothek.gui.dock.title.ControllerTitleFactory;
import bibliothek.gui.dock.title.DockTitle;
import bibliothek.gui.dock.title.DockTitleVersion;
import bibliothek.gui.dock.util.DockUtilities;
import bibliothek.gui.dock.util.PropertyKey;
import bibliothek.gui.dock.util.PropertyValue;
import bibliothek.gui.dock.util.property.ConstantPropertyFactory;
import bibliothek.util.Path;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.GridLayout;
import java.awt.Point;
import java.awt.Rectangle;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.MouseInputListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StackDockStation
extends AbstractDockableStation
implements StackDockComponentParent {
    public static final String TITLE_ID = "stack";
    public static final PropertyKey<StackDockComponentFactory> COMPONENT_FACTORY = new PropertyKey("stack dock component factory");
    public static final PropertyKey<TabPlacement> TAB_PLACEMENT = new PropertyKey<TabPlacement>("stack dock station tab side", new ConstantPropertyFactory<TabPlacement>(TabPlacement.TOP_OF_DOCKABLE), true);
    public static final PropertyKey<TabContentFilter> TAB_CONTENT_FILTER = new PropertyKey("stack dock tab content filter");
    private PlaceholderList<StationChildHandle> dockables = new PlaceholderList();
    private List<MouseInputListener> mouseInputListeners = new ArrayList<MouseInputListener>();
    private DockableVisibilityManager visibility;
    private StationPaintWrapper paint = new StationPaintWrapper();
    private DisplayerFactoryWrapper displayerFactory = new DisplayerFactoryWrapper();
    private DisplayerCollection displayers;
    private Dockable dropping;
    private boolean draw = false;
    private Insert insert;
    private Background background;
    private JComponent panel;
    private StackDockComponent stackComponent;
    private StackDockComponentRepresentative stackComponentRepresentative;
    private PropertyValue<StackDockComponentFactory> stackComponentFactory;
    private PropertyValue<TabPlacement> tabPlacement;
    private DockTitleVersion title;
    private Listener listener = new Listener();
    private PropertyValue<PlaceholderStrategy> placeholderStrategy = new PropertyValue<PlaceholderStrategy>(PlaceholderStrategy.PLACEHOLDER_STRATEGY){

        @Override
        protected void valueChanged(PlaceholderStrategy placeholderStrategy, PlaceholderStrategy placeholderStrategy2) {
            StackDockStation.this.dockables.setStrategy(placeholderStrategy2);
        }
    };
    private PropertyValue<TabContentFilter> tabContentFilter = new PropertyValue<TabContentFilter>(TAB_CONTENT_FILTER){

        @Override
        protected void valueChanged(TabContentFilter tabContentFilter, TabContentFilter tabContentFilter2) {
            if (tabContentFilter != tabContentFilter2) {
                if (tabContentFilter != null) {
                    tabContentFilter.removeListener(StackDockStation.this.tabContentFilterListener);
                    tabContentFilter.uninstall(StackDockStation.this);
                }
                if (tabContentFilter2 != null) {
                    tabContentFilter2.install(StackDockStation.this);
                    tabContentFilter2.addListener(StackDockStation.this.tabContentFilterListener);
                }
                StackDockStation.this.tabContentFilterListener.contentChanged();
            }
        }
    };
    private TabContentFilterListener tabContentFilterListener = new TabContentFilterListener(){

        public void contentChanged() {
            int n = StackDockStation.this.getDockableCount();
            for (int i = 0; i < n; ++i) {
                StackDockStation.this.updateContent(i);
            }
        }

        public void contentChanged(StackDockComponent stackDockComponent) {
        }

        public void contentChanged(StackDockStation stackDockStation) {
            if (StackDockStation.this == stackDockStation) {
                this.contentChanged();
            }
        }

        public void contentChanged(Dockable dockable) {
            int n;
            if (dockable.getDockParent() == StackDockStation.this && (n = StackDockStation.this.indexOf(dockable)) >= 0) {
                StackDockStation.this.updateContent(n);
            }
        }
    };
    private VisibleListener visibleListener;
    private Dockable lastSelectedDockable = null;

    public StackDockStation() {
        this(null);
    }

    public StackDockStation(DockTheme dockTheme) {
        super(dockTheme);
        this.init();
    }

    protected StackDockStation(DockTheme dockTheme, boolean bl) {
        super(dockTheme);
        if (bl) {
            this.init();
        }
    }

    protected void init() {
        this.visibleListener = new VisibleListener();
        this.visibility = new DockableVisibilityManager(this.listeners);
        this.displayers = new DisplayerCollection(this, this.displayerFactory);
        this.displayers.addDockableDisplayerListener(new DockableDisplayerListener(){

            public void discard(DockableDisplayer dockableDisplayer) {
                StackDockStation.this.discard(dockableDisplayer);
            }
        });
        this.background = this.createBackground();
        this.panel = this.background.getContentPane();
        this.stackComponentFactory = new PropertyValue<StackDockComponentFactory>(COMPONENT_FACTORY){

            @Override
            protected void valueChanged(StackDockComponentFactory stackDockComponentFactory, StackDockComponentFactory stackDockComponentFactory2) {
                if (stackDockComponentFactory2 == null) {
                    StackDockStation.this.setStackComponent(StackDockStation.this.createStackDockComponent());
                } else {
                    StackDockStation.this.setStackComponent(stackDockComponentFactory2.create(StackDockStation.this));
                }
            }
        };
        this.tabPlacement = new PropertyValue<TabPlacement>(TAB_PLACEMENT){

            @Override
            protected void valueChanged(TabPlacement tabPlacement, TabPlacement tabPlacement2) {
                if (StackDockStation.this.stackComponent != null) {
                    StackDockStation.this.stackComponent.setTabPlacement(tabPlacement2);
                }
            }
        };
        this.stackComponent = this.createStackDockComponent();
        this.stackComponent.addChangeListener(this.visibleListener);
        this.stackComponentRepresentative = new StackDockComponentRepresentative();
        this.stackComponentRepresentative.setComponent(this.stackComponent);
        this.stackComponentRepresentative.setTarget(this);
        this.addDockStationListener(new DockStationAdapter(){

            public void dockableSelected(DockStation dockStation, Dockable dockable, Dockable dockable2) {
                StackDockStation.this.lastSelectedDockable = dockable2;
            }
        });
    }

    protected Background createBackground() {
        return new Background();
    }

    protected StackDockComponent createStackDockComponent() {
        return new DefaultStackDockComponent();
    }

    @Override
    public DockStation getStation() {
        return this;
    }

    public void setTabPlacement(TabPlacement tabPlacement) {
        this.tabPlacement.setValue(tabPlacement);
    }

    public TabPlacement getTabPlacement() {
        return this.tabPlacement.getValue();
    }

    public void setTabContentFilter(TabContentFilter tabContentFilter) {
        this.tabContentFilter.setValue(tabContentFilter);
    }

    public TabContentFilter getTabContentFilter() {
        return this.tabContentFilter.getValue();
    }

    protected boolean singleTabStackDockComponent() {
        StackDockComponent stackDockComponent = this.getStackComponent();
        if (stackDockComponent == null) {
            return false;
        }
        return stackDockComponent.isSingleTabComponent();
    }

    public void setStackComponent(StackDockComponent stackDockComponent) {
        if (stackDockComponent == null) {
            throw new IllegalArgumentException("Component must not be null");
        }
        if (stackDockComponent != this.stackComponent) {
            Object object;
            int n = -1;
            if (this.stackComponent != null) {
                this.stackComponent.setController(null);
                object = this.stackComponent.getComponent();
                for (MouseInputListener mouseInputListener : this.mouseInputListeners) {
                    ((Component)object).removeMouseListener(mouseInputListener);
                    ((Component)object).removeMouseMotionListener(mouseInputListener);
                }
                n = this.stackComponent.getSelectedIndex();
                this.stackComponent.removeChangeListener(this.visibleListener);
                this.stackComponent.removeAll();
            }
            this.stackComponent = stackDockComponent;
            stackDockComponent.setTabPlacement(this.tabPlacement.getValue());
            this.stackComponentRepresentative.setComponent(stackDockComponent);
            if (this.getDockableCount() < 2 && !this.singleTabStackDockComponent()) {
                stackDockComponent.addChangeListener(this.visibleListener);
            } else {
                this.panel.removeAll();
                for (StationChildHandle stationChildHandle : this.dockables.dockables()) {
                    DockableDisplayer dockableDisplayer = stationChildHandle.getDisplayer();
                    int n2 = stackDockComponent.getTabCount();
                    this.insertTab(dockableDisplayer, n2);
                }
                this.panel.add(stackDockComponent.getComponent());
                if (n >= 0 && n < stackDockComponent.getTabCount()) {
                    stackDockComponent.setSelectedIndex(n);
                }
                stackDockComponent.addChangeListener(this.visibleListener);
            }
            object = stackDockComponent.getComponent();
            stackDockComponent.setController(this.getController());
            for (MouseInputListener mouseInputListener : this.mouseInputListeners) {
                ((Component)object).addMouseListener(mouseInputListener);
                ((Component)object).addMouseMotionListener(mouseInputListener);
            }
            this.updateConfigurableDisplayerHints();
        }
    }

    public StackDockComponent getStackComponent() {
        return this.stackComponent;
    }

    public void setStackComponentFactory(StackDockComponentFactory stackDockComponentFactory) {
        this.stackComponentFactory.setValue(stackDockComponentFactory);
    }

    public StackDockComponentFactory getStackComponentFactory() {
        return this.stackComponentFactory.getOwnValue();
    }

    @Override
    protected void callDockUiUpdateTheme() throws IOException {
        DockUI.updateTheme(this, new StackDockStationFactory());
    }

    @Override
    public void setDockParent(DockStation dockStation) {
        DockStation dockStation2 = this.getDockParent();
        if (dockStation2 != null) {
            dockStation2.removeDockStationListener(this.visibleListener);
        }
        super.setDockParent(dockStation);
        if (dockStation != null) {
            dockStation.addDockStationListener(this.visibleListener);
        }
        this.visibility.fire();
    }

    @Override
    public void setController(DockController dockController) {
        if (this.getController() != dockController) {
            boolean bl;
            for (StationChildHandle stationChildHandle : this.dockables.dockables()) {
                stationChildHandle.setTitleRequest(null);
            }
            boolean bl2 = this.getController() == null;
            this.stackComponentFactory.setProperties(dockController);
            super.setController(dockController);
            this.stackComponent.setController(dockController);
            this.tabPlacement.setProperties(dockController);
            this.placeholderStrategy.setProperties(dockController);
            this.tabContentFilter.setProperties(dockController);
            this.stackComponentRepresentative.setController(dockController);
            this.title = dockController != null ? dockController.getDockTitleManager().getVersion(TITLE_ID, ControllerTitleFactory.INSTANCE) : null;
            this.displayers.setController(dockController);
            boolean bl3 = bl = dockController == null;
            if (bl2 != bl) {
                if (bl2) {
                    this.dockables.bind();
                } else {
                    this.dockables.unbind();
                }
            }
            for (StationChildHandle stationChildHandle : this.dockables.dockables()) {
                stationChildHandle.setTitleRequest(this.title, true);
            }
        }
    }

    public StationPaintWrapper getPaint() {
        return this.paint;
    }

    public DisplayerFactoryWrapper getDisplayerFactory() {
        return this.displayerFactory;
    }

    public DisplayerCollection getDisplayers() {
        return this.displayers;
    }

    @Override
    public boolean isStationVisible() {
        DockStation dockStation = this.getDockParent();
        if (dockStation != null) {
            return dockStation.isVisible(this);
        }
        return this.panel.isDisplayable();
    }

    @Override
    public boolean isVisible(Dockable dockable) {
        return this.isStationVisible() && (this.dockables.dockables().size() == 1 || this.indexOf(dockable) == this.stackComponent.getSelectedIndex());
    }

    @Override
    public int getDockableCount() {
        return this.dockables.dockables().size();
    }

    @Override
    public Dockable getDockable(int n) {
        return this.dockables.dockables().get(n).getDockable();
    }

    @Override
    public DockableProperty getDockableProperty(Dockable dockable, Dockable dockable2) {
        int n = this.indexOf(dockable);
        PlaceholderStrategy placeholderStrategy = this.getPlaceholderStrategy();
        Path path = null;
        if (placeholderStrategy != null && (path = placeholderStrategy.getPlaceholderFor(dockable2 == null ? dockable : dockable2)) != null) {
            this.dockables.dockables().addPlaceholder(n, path);
        }
        return new StackDockProperty(n, path);
    }

    @Override
    public Dockable getFrontDockable() {
        if (this.dockables.dockables().size() == 0) {
            return null;
        }
        if (this.dockables.dockables().size() == 1) {
            return this.dockables.dockables().get(0).getDockable();
        }
        int n = this.stackComponent.getSelectedIndex();
        if (n >= 0) {
            return this.dockables.dockables().get(n).getDockable();
        }
        return null;
    }

    @Override
    public void setFrontDockable(Dockable dockable) {
        if (this.dockables.dockables().size() > 1 && dockable != null) {
            this.stackComponent.setSelectedIndex(this.indexOf(dockable));
        }
        this.fireDockableSelected();
    }

    protected void fireDockableSelected() {
        Dockable dockable = this.getFrontDockable();
        if (this.lastSelectedDockable != dockable) {
            this.listeners.fireDockableSelected(this.lastSelectedDockable, dockable);
        }
    }

    @Override
    public int indexOf(Dockable dockable) {
        int n = 0;
        for (StationChildHandle stationChildHandle : this.dockables.dockables()) {
            if (stationChildHandle.getDockable() == dockable) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    @Override
    public PlaceholderMap getPlaceholders() {
        return this.dockables.toMap();
    }

    @Override
    public void setPlaceholders(PlaceholderMap placeholderMap) {
        if (this.getDockableCount() > 0) {
            throw new IllegalStateException("there are children on this station");
        }
        try {
            PlaceholderList placeholderList = new PlaceholderList(placeholderMap);
            if (this.getController() != null) {
                this.dockables.setStrategy(null);
                this.dockables.unbind();
                this.dockables = placeholderList;
                this.dockables.bind();
                this.dockables.setStrategy(this.getPlaceholderStrategy());
            } else {
                this.dockables = placeholderList;
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public PlaceholderMap getPlaceholders(final Map<Dockable, Integer> map) {
        this.dockables.insertAllPlaceholders();
        final PlaceholderStrategy placeholderStrategy = this.getPlaceholderStrategy();
        return this.dockables.toMap((PlaceholderListItemConverter<StationChildHandle>)new PlaceholderListItemAdapter<StationChildHandle>(){

            @Override
            public ConvertedPlaceholderListItem convert(int n, StationChildHandle stationChildHandle) {
                Path path;
                ConvertedPlaceholderListItem convertedPlaceholderListItem = new ConvertedPlaceholderListItem();
                convertedPlaceholderListItem.putInt("id", (Integer)map.get(stationChildHandle.getDockable()));
                convertedPlaceholderListItem.putInt("index", n);
                if (placeholderStrategy != null && (path = placeholderStrategy.getPlaceholderFor(stationChildHandle.getDockable())) != null) {
                    convertedPlaceholderListItem.putString("placeholder", path.toString());
                    convertedPlaceholderListItem.setPlaceholder(path);
                }
                return convertedPlaceholderListItem;
            }

            @Override
            public StationChildHandle convert(ConvertedPlaceholderListItem convertedPlaceholderListItem) {
                return null;
            }
        });
    }

    public void setPlaceholders(PlaceholderMap placeholderMap, final Map<Integer, Dockable> map) {
        if (this.getDockableCount() > 0) {
            throw new IllegalStateException("there are children on this station");
        }
        this.dockables.setStrategy(null);
        this.dockables.unbind();
        PlaceholderList<StationChildHandle> placeholderList = new PlaceholderList<StationChildHandle>();
        this.dockables = placeholderList;
        placeholderList.read(placeholderMap, new PlaceholderListItemAdapter<StationChildHandle>(){
            private int size = 0;

            @Override
            public StationChildHandle convert(ConvertedPlaceholderListItem convertedPlaceholderListItem) {
                int n = convertedPlaceholderListItem.getInt("id");
                Dockable dockable = (Dockable)map.get(n);
                if (dockable == null) {
                    return null;
                }
                StackDockStation.this.listeners.fireDockableAdding(dockable);
                dockable.addDockableListener(StackDockStation.this.listener);
                StationChildHandle stationChildHandle = new StationChildHandle(StackDockStation.this, StackDockStation.this.getDisplayers(), dockable, StackDockStation.this.title);
                return stationChildHandle;
            }

            @Override
            public void added(StationChildHandle stationChildHandle) {
                Dockable dockable = stationChildHandle.getDockable();
                dockable.setDockParent(StackDockStation.this);
                stationChildHandle.updateDisplayer();
                StackDockStation.this.addToPanel(stationChildHandle, this.size, this.size);
                ++this.size;
                StackDockStation.this.listeners.fireDockableAdded(dockable);
            }
        });
        if (this.getController() != null) {
            this.dockables.bind();
            this.dockables.setStrategy(this.getPlaceholderStrategy());
        }
    }

    public PlaceholderStrategy getPlaceholderStrategy() {
        return this.placeholderStrategy.getValue();
    }

    public void setPlaceholderStrategy(PlaceholderStrategy placeholderStrategy) {
        this.placeholderStrategy.setValue(placeholderStrategy);
    }

    @Override
    public boolean prepareDrop(int n, int n2, int n3, int n4, boolean bl, Dockable dockable) {
        if (SwingUtilities.isDescendingFrom(this.getComponent(), dockable.getComponent())) {
            this.setInsert(null, null);
            return false;
        }
        DockStation dockStation = this.getDockParent();
        Point point = new Point(n, n2);
        SwingUtilities.convertPointFromScreen(point, this.panel);
        if (dockStation != null && bl && dockStation.isInOverrideZone(n, n2, this, dockable)) {
            DockTitle dockTitle;
            if (this.dockables.dockables().size() > 1) {
                if (this.setInsert(this.exactTabIndexAt(point.x, point.y), dockable)) {
                    return true;
                }
            } else if (this.dockables.dockables().size() == 1 && (dockTitle = this.dockables.dockables().get(0).getDisplayer().getTitle()) != null) {
                Component component = dockTitle.getComponent();
                Point point2 = new Point(n, n2);
                SwingUtilities.convertPointFromScreen(point2, component);
                if (component.getBounds().contains(point2)) {
                    return this.setInsert(new Insert(0, true), dockable);
                }
            }
            return false;
        }
        return this.setInsert(this.tabIndexAt(point.x, point.y), dockable);
    }

    @Override
    public void drop() {
        this.listeners.fireDockableAdding(this.dropping);
        this.add(this.dropping, this.insert.tab + (this.insert.right ? 1 : 0), null, false);
        this.listeners.fireDockableAdded(this.dropping);
    }

    @Override
    public void drop(Dockable dockable) {
        this.drop(dockable, true);
    }

    public void drop(Dockable dockable, boolean bl) {
        Path path = null;
        if (bl) {
            PlaceholderStrategy placeholderStrategy = this.getPlaceholderStrategy();
            path = placeholderStrategy == null ? null : placeholderStrategy.getPlaceholderFor(dockable);
        }
        boolean bl2 = false;
        if (path != null) {
            bl2 = this.drop(dockable, new StackDockProperty(this.dockables.dockables().size(), path));
        }
        if (!bl2) {
            this.listeners.fireDockableAdding(dockable);
            this.add(dockable, this.dockables.dockables().size(), null, false);
            this.listeners.fireDockableAdded(dockable);
        }
    }

    @Override
    public boolean drop(Dockable dockable, DockableProperty dockableProperty) {
        if (dockableProperty instanceof StackDockProperty) {
            return this.drop(dockable, (StackDockProperty)dockableProperty);
        }
        return false;
    }

    public boolean drop(Dockable dockable, StackDockProperty stackDockProperty) {
        Object object;
        DockUtilities.ensureTreeValidity(this, dockable);
        int n = stackDockProperty.getIndex();
        Path path = stackDockProperty.getPlaceholder();
        boolean bl = this.acceptable(dockable);
        DockableProperty dockableProperty = stackDockProperty.getSuccessor();
        boolean bl2 = false;
        if (path != null && dockableProperty != null) {
            DockStation dockStation;
            object = this.dockables.getDockableAt(path);
            if (object != null && (dockStation = ((StationChildHandle)object).getDockable().asDockStation()) != null && dockStation.drop(dockable, dockableProperty)) {
                bl2 = true;
                this.dockables.removeAll(path);
            }
        } else if (path != null && bl && this.dockables.hasPlaceholder(path)) {
            this.add(dockable, 0, path, true);
            bl2 = true;
        }
        if (!bl2 && this.dockables.dockables().size() == 0 && bl) {
            this.drop(dockable, false);
            bl2 = true;
        }
        if (!bl2) {
            if ((n = Math.min(n, this.dockables.dockables().size())) < this.dockables.dockables().size() && dockableProperty != null && (object = this.dockables.dockables().get(n).getDockable().asDockStation()) != null && object.drop(dockable, dockableProperty)) {
                bl2 = true;
            }
            if (!bl2 && bl) {
                this.add(dockable, n);
                bl2 = true;
            }
        }
        return bl2;
    }

    @Override
    public boolean prepareMove(int n, int n2, int n3, int n4, boolean bl, Dockable dockable) {
        DockStation dockStation = this.getDockParent();
        Point point = new Point(n, n2);
        SwingUtilities.convertPointFromScreen(point, this.panel);
        if (dockStation != null && bl && dockStation.isInOverrideZone(n, n2, this, dockable)) {
            return this.dockables.dockables().size() > 1 && this.setInsert(this.exactTabIndexAt(point.x, point.y), dockable);
        }
        return this.setInsert(this.tabIndexAt(point.x, point.y), dockable);
    }

    private boolean setInsert(Insert insert, Dockable dockable) {
        if (insert != null && this.accept(dockable) && dockable.accept(this) && this.getController().getAcceptance().accept(this, dockable)) {
            this.insert = insert;
            this.dropping = dockable;
        } else {
            this.insert = null;
            this.dropping = null;
        }
        return this.insert != null;
    }

    public Insert getInsert() {
        return this.insert;
    }

    @Override
    public void move() {
        int n = this.indexOf(this.dropping);
        if (n >= 0) {
            int n2 = this.insert.tab + (this.insert.right ? 1 : 0);
            if (n2 > n) {
                --n2;
            }
            this.move(n, n2);
        }
    }

    @Override
    public void move(Dockable dockable, DockableProperty dockableProperty) {
        if (dockableProperty instanceof StackDockProperty) {
            int n = this.indexOf(dockable);
            if (n < 0) {
                throw new IllegalArgumentException("dockable not child of this station");
            }
            int n2 = ((StackDockProperty)dockableProperty).getIndex();
            n2 = Math.min(n2, this.getDockableCount() - 1);
            this.move(n, n2);
        }
    }

    private void move(int n, int n2) {
        if (n != n2) {
            this.dockables.dockables().move(n, n2);
            this.stackComponent.moveTab(n, n2);
        }
    }

    protected Insert tabIndexAt(int n, int n2) {
        if (this.dockables.dockables().size() == 0) {
            return new Insert(0, false);
        }
        if (this.dockables.dockables().size() == 1) {
            return new Insert(1, false);
        }
        Insert insert = this.exactTabIndexAt(n, n2);
        if (insert == null) {
            insert = new Insert(this.dockables.dockables().size() - 1, true);
        }
        return insert;
    }

    protected Insert exactTabIndexAt(int n, int n2) {
        Point point = SwingUtilities.convertPoint(this.panel, n, n2, this.stackComponent.getComponent());
        int n3 = this.dockables.dockables().size();
        for (int i = 0; i < n3; ++i) {
            Rectangle rectangle = this.stackComponent.getBoundsAt(i);
            if (rectangle == null || !rectangle.contains(point)) continue;
            if (this.tabPlacement.getValue().isHorizontal()) {
                return new Insert(i, rectangle.x + rectangle.width / 2 < point.x);
            }
            return new Insert(i, rectangle.y + rectangle.height / 2 < point.y);
        }
        return null;
    }

    @Override
    public void draw() {
        this.draw = true;
        this.panel.repaint();
    }

    @Override
    public void forget() {
        this.draw = false;
        this.insert = null;
        this.dropping = null;
        this.panel.repaint();
    }

    @Override
    public <D extends Dockable & DockStation> boolean isInOverrideZone(int n, int n2, D d, Dockable dockable) {
        DockStation dockStation = this.getDockParent();
        if (dockStation != null) {
            return dockStation.isInOverrideZone(n, n2, d, dockable);
        }
        return false;
    }

    @Override
    public boolean canDrag(Dockable dockable) {
        return true;
    }

    @Override
    public void drag(Dockable dockable) {
        if (dockable.getDockParent() != this) {
            throw new IllegalArgumentException("The dockable can't be dragged, it is not child of this station");
        }
        int n = this.indexOf(dockable);
        if (n < 0) {
            throw new IllegalArgumentException("The dockable is not part of this station.");
        }
        this.listeners.fireDockableRemoving(dockable);
        this.remove(n, false);
        this.listeners.fireDockableRemoved(dockable);
    }

    @Override
    public boolean canReplace(Dockable dockable, Dockable dockable2) {
        return true;
    }

    @Override
    public void replace(DockStation dockStation, Dockable dockable) {
        this.replace(dockStation.asDockable(), dockable, true);
    }

    @Override
    public void replace(Dockable dockable, Dockable dockable2) {
        this.replace(dockable, dockable2, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void replace(Dockable dockable, Dockable dockable2, boolean bl) {
        DockController dockController = this.getController();
        try {
            if (dockController != null) {
                dockController.freezeLayout();
            }
            int n = this.indexOf(dockable);
            int n2 = this.dockables.levelToBase(n, PlaceholderList.Level.DOCKABLE);
            PlaceholderList.Item item = this.dockables.list().get(n2);
            this.remove(n);
            this.add(dockable2, n);
            PlaceholderList.Item item2 = this.dockables.list().get(n2);
            if (bl) {
                item2.setPlaceholderMap(dockable.asDockStation().getPlaceholders());
            } else {
                item2.setPlaceholderMap(item.getPlaceholderMap());
            }
            item2.setPlaceholderSet(item.getPlaceholderSet());
        }
        finally {
            if (dockController != null) {
                dockController.meltLayout();
            }
        }
    }

    public void add(Dockable dockable, int n) {
        this.add(dockable, n, null, true);
    }

    protected void add(Dockable dockable, int n, Path path, boolean bl) {
        int n2;
        DockUtilities.ensureTreeValidity(this, dockable);
        if (bl) {
            this.listeners.fireDockableAdding(dockable);
        }
        dockable.setDockParent(this);
        StationChildHandle stationChildHandle = new StationChildHandle(this, this.getDisplayers(), dockable, this.title);
        stationChildHandle.updateDisplayer();
        int n3 = n2 = path == null ? -1 : this.dockables.put(path, stationChildHandle);
        if (n2 == -1) {
            this.dockables.dockables().add(n, stationChildHandle);
        } else {
            n = n2;
        }
        this.addToPanel(stationChildHandle, n, this.dockables.dockables().size() - 1);
        dockable.addDockableListener(this.listener);
        if (bl) {
            this.listeners.fireDockableAdded(dockable);
        }
        this.fireDockableSelected();
    }

    protected void addToPanel(StationChildHandle stationChildHandle, int n, int n2) {
        if (n2 == 0 && !this.singleTabStackDockComponent()) {
            DockableDisplayer dockableDisplayer = stationChildHandle.getDisplayer();
            this.panel.add(dockableDisplayer.getComponent());
        } else {
            Object object;
            int n3 = n;
            if (n2 == 1 && !this.singleTabStackDockComponent()) {
                this.panel.removeAll();
                object = this.dockables.dockables();
                if (object.get(0) == stationChildHandle) {
                    if (object.size() != 2) {
                        throw new IllegalStateException("handle is stored, size is 1, but number of known dockables is not 2");
                    }
                    stationChildHandle = (StationChildHandle)object.get(1);
                    n = 1;
                }
                DockableDisplayer dockableDisplayer = ((StationChildHandle)object.get(0)).getDisplayer();
                this.insertTab(dockableDisplayer, 0);
                this.panel.add(this.stackComponent.getComponent());
            }
            object = stationChildHandle.getDisplayer();
            this.insertTab((DockableDisplayer)object, n);
            this.stackComponent.setSelectedIndex(n3);
        }
        this.panel.revalidate();
        this.panel.repaint();
    }

    private void insertTab(DockableDisplayer dockableDisplayer, int n) {
        Dockable dockable = dockableDisplayer.getDockable();
        String string = dockable.getTitleText();
        String string2 = dockable.getTitleToolTip();
        Icon icon = dockable.getTitleIcon();
        TabContentFilter tabContentFilter = this.getTabContentFilter();
        if (tabContentFilter != null) {
            TabContent tabContent = new TabContent(icon, string, string2);
            if ((tabContent = tabContentFilter.filter(tabContent, this, dockable)) == null) {
                string = null;
                string2 = null;
                icon = null;
            } else {
                string = tabContent.getTitle();
                string2 = tabContent.getTooltip();
                icon = tabContent.getIcon();
            }
        }
        this.stackComponent.insertTab(string, icon, dockableDisplayer.getComponent(), dockable, n);
        this.stackComponent.setTooltipAt(n, string2);
    }

    protected void discard(DockableDisplayer dockableDisplayer) {
        Dockable dockable = dockableDisplayer.getDockable();
        int n = this.indexOf(dockable);
        if (n < 0) {
            throw new IllegalArgumentException("displayer is not a child of this station: " + dockableDisplayer);
        }
        StationChildHandle stationChildHandle = this.dockables.dockables().get(n);
        stationChildHandle.updateDisplayer();
        dockableDisplayer = stationChildHandle.getDisplayer();
        if (this.dockables.dockables().size() == 1 && this.singleTabStackDockComponent()) {
            this.panel.removeAll();
            this.panel.add(dockableDisplayer.getComponent());
        } else {
            this.stackComponent.setComponentAt(n, dockableDisplayer.getComponent());
        }
    }

    public void remove(int n) {
        this.remove(n, true);
    }

    private void remove(int n, boolean bl) {
        if (n < 0 || n >= this.dockables.dockables().size()) {
            throw new IllegalArgumentException("Index out of bounds");
        }
        StationChildHandle stationChildHandle = this.dockables.dockables().get(n);
        Dockable dockable = stationChildHandle.getDockable();
        if (bl) {
            this.listeners.fireDockableRemoving(dockable);
        }
        if (this.dockables.dockables().size() == 1) {
            if (this.singleTabStackDockComponent()) {
                this.stackComponent.remove(0);
            } else {
                this.panel.remove(this.dockables.dockables().get(0).getDisplayer().getComponent());
            }
            this.dockables.remove(0);
            this.panel.repaint();
        } else if (this.dockables.dockables().size() == 2 && !this.singleTabStackDockComponent()) {
            this.panel.remove(this.stackComponent.getComponent());
            this.dockables.remove(n);
            this.stackComponent.removeAll();
            this.panel.add(this.dockables.dockables().get(0).getDisplayer().getComponent());
        } else {
            this.dockables.remove(n);
            this.stackComponent.remove(n);
        }
        stationChildHandle.destroy();
        dockable.removeDockableListener(this.listener);
        this.panel.revalidate();
        dockable.setDockParent(null);
        if (bl) {
            this.listeners.fireDockableRemoved(dockable);
        }
        this.fireDockableSelected();
    }

    @Override
    public Component getComponent() {
        return this.background;
    }

    @Override
    public void configureDisplayerHints(DockableDisplayerHints dockableDisplayerHints) {
        super.configureDisplayerHints(dockableDisplayerHints);
        this.updateConfigurableDisplayerHints();
    }

    protected void updateConfigurableDisplayerHints() {
        DockableDisplayerHints dockableDisplayerHints = this.getConfigurableDisplayerHints();
        if (dockableDisplayerHints != null) {
            dockableDisplayerHints.setShowBorderHint(!this.getStackComponent().hasBorder());
        }
    }

    @Override
    public void addMouseInputListener(MouseInputListener mouseInputListener) {
        this.panel.addMouseListener(mouseInputListener);
        this.panel.addMouseMotionListener(mouseInputListener);
        this.mouseInputListeners.add(mouseInputListener);
        if (this.stackComponent != null) {
            this.stackComponent.getComponent().addMouseListener(mouseInputListener);
            this.stackComponent.getComponent().addMouseMotionListener(mouseInputListener);
        }
    }

    @Override
    public void removeMouseInputListener(MouseInputListener mouseInputListener) {
        this.panel.removeMouseListener(mouseInputListener);
        this.panel.removeMouseMotionListener(mouseInputListener);
        this.mouseInputListeners.remove(mouseInputListener);
        if (this.stackComponent != null) {
            this.stackComponent.getComponent().removeMouseListener(mouseInputListener);
            this.stackComponent.getComponent().removeMouseMotionListener(mouseInputListener);
        }
    }

    @Override
    public String getFactoryID() {
        return "StackDockStationFactory";
    }

    private void updateContent(int n) {
        if (n >= 0 && (this.getDockableCount() > 1 || this.singleTabStackDockComponent())) {
            Dockable dockable = this.getDockable(n);
            TabContentFilter tabContentFilter = this.getTabContentFilter();
            TabContent tabContent = new TabContent(dockable.getTitleIcon(), dockable.getTitleText(), dockable.getTitleToolTip());
            if (tabContentFilter != null) {
                tabContent = tabContentFilter.filter(tabContent, this, dockable);
            }
            if (tabContent == null) {
                this.stackComponent.setTitleAt(n, null);
                this.stackComponent.setIconAt(n, null);
                this.stackComponent.setTooltipAt(n, null);
            } else {
                this.stackComponent.setTitleAt(n, tabContent.getTitle());
                this.stackComponent.setIconAt(n, tabContent.getIcon());
                this.stackComponent.setTooltipAt(n, tabContent.getTooltip());
            }
        }
    }

    protected void insertionLine(Rectangle rectangle, Rectangle rectangle2, Point point, Point point2, boolean bl) {
        if (this.tabPlacement.getValue().isHorizontal()) {
            if (rectangle != null && rectangle2 != null) {
                int n;
                int n2 = Math.max(rectangle.y, rectangle2.y);
                int n3 = Math.min(rectangle.y + rectangle.height, rectangle2.y + rectangle2.height);
                if (n3 > n2 && (double)(n = n3 - n2) >= 0.8 * (double)rectangle.height && (double)n >= 0.8 * (double)rectangle2.height) {
                    point.x = (rectangle.x + rectangle.width + rectangle2.x) / 2;
                    point.y = n2;
                    point2.x = point.x;
                    point2.y = n3;
                    return;
                }
            }
            if (bl) {
                point.x = rectangle.x + rectangle.width;
                point.y = rectangle.y;
                point2.x = point.x;
                point2.y = point.y + rectangle.height;
            } else {
                point.x = rectangle2.x;
                point.y = rectangle2.y;
                point2.x = point.x;
                point2.y = point.y + rectangle2.height;
            }
        } else {
            if (rectangle != null && rectangle2 != null) {
                int n;
                int n4 = Math.max(rectangle.x, rectangle2.x);
                int n5 = Math.min(rectangle.x + rectangle.width, rectangle2.x + rectangle2.width);
                if (n5 > n4 && (double)(n = n5 - n4) >= 0.8 * (double)rectangle.width && (double)n >= 0.8 * (double)rectangle2.width) {
                    point.y = (rectangle.y + rectangle.height + rectangle2.y) / 2;
                    point.x = n4;
                    point2.y = point.y;
                    point2.x = n5;
                    return;
                }
            }
            if (bl) {
                point.y = rectangle.y + rectangle.height;
                point.x = rectangle.x;
                point2.y = point.y;
                point2.x = point.x + rectangle.width;
            } else {
                point.y = rectangle2.y;
                point.x = rectangle2.x;
                point2.y = point.y;
                point2.x = point.x + rectangle2.width;
            }
        }
    }

    public static class Insert {
        private final int tab;
        private final boolean right;

        public Insert(int n, boolean bl) {
            this.tab = n;
            this.right = bl;
        }

        public int getTab() {
            return this.tab;
        }

        public boolean isRight() {
            return this.right;
        }
    }

    protected class Background
    extends OverpaintablePanel {
        public Background() {
            this.getContentPane().setLayout(new GridLayout(1, 1));
        }

        protected void paintOverlay(Graphics graphics) {
            Cloneable cloneable;
            Rectangle rectangle;
            StationPaintWrapper stationPaintWrapper = StackDockStation.this.getPaint();
            if (StackDockStation.this.draw && StackDockStation.this.dockables.dockables().size() > 1 && StackDockStation.this.insert != null) {
                rectangle = null;
                if (StackDockStation.this.insert.tab >= 0 && StackDockStation.this.insert.tab < StackDockStation.this.stackComponent.getTabCount()) {
                    rectangle = StackDockStation.this.stackComponent.getBoundsAt(StackDockStation.this.insert.tab);
                }
                if (rectangle != null) {
                    cloneable = new Point();
                    Point point = new Point();
                    if (StackDockStation.this.insert.right) {
                        StackDockStation.this.insertionLine(rectangle, StackDockStation.this.insert.tab + 1 < StackDockStation.this.stackComponent.getTabCount() ? StackDockStation.this.stackComponent.getBoundsAt(StackDockStation.this.insert.tab + 1) : null, (Point)cloneable, point, true);
                    } else {
                        StackDockStation.this.insertionLine(StackDockStation.this.insert.tab > 0 ? StackDockStation.this.stackComponent.getBoundsAt(StackDockStation.this.insert.tab - 1) : null, rectangle, (Point)cloneable, point, false);
                    }
                    stationPaintWrapper.drawInsertionLine(graphics, StackDockStation.this, ((Point)cloneable).x, ((Point)cloneable).y, point.x, point.y);
                }
            }
            if (StackDockStation.this.draw) {
                rectangle = new Rectangle(0, 0, this.getWidth(), this.getHeight());
                cloneable = null;
                if (StackDockStation.this.getDockableCount() < 2) {
                    cloneable = rectangle;
                } else {
                    int n = StackDockStation.this.stackComponent.getSelectedIndex();
                    if (n >= 0) {
                        Component component = ((StationChildHandle)StackDockStation.this.dockables.dockables().get(n)).getDisplayer().getComponent();
                        Point point = new Point(0, 0);
                        point = SwingUtilities.convertPoint(component, point, this);
                        cloneable = new Rectangle(point.x, point.y, component.getWidth(), component.getHeight());
                    }
                }
                if (cloneable != null) {
                    stationPaintWrapper.drawInsertion(graphics, StackDockStation.this, rectangle, (Rectangle)cloneable);
                }
            }
        }
    }

    private class Listener
    implements DockableListener {
        private Listener() {
        }

        public void titleBound(Dockable dockable, DockTitle dockTitle) {
        }

        public void titleUnbound(Dockable dockable, DockTitle dockTitle) {
        }

        public void titleTextChanged(Dockable dockable, String string, String string2) {
            if (StackDockStation.this.dockables.dockables().size() > 1) {
                int n = StackDockStation.this.indexOf(dockable);
                StackDockStation.this.updateContent(n);
            }
        }

        public void titleToolTipChanged(Dockable dockable, String string, String string2) {
            if (StackDockStation.this.dockables.dockables().size() > 1) {
                int n = StackDockStation.this.indexOf(dockable);
                StackDockStation.this.updateContent(n);
            }
        }

        public void titleIconChanged(Dockable dockable, Icon icon, Icon icon2) {
            if (StackDockStation.this.dockables.dockables().size() > 1) {
                int n = StackDockStation.this.indexOf(dockable);
                StackDockStation.this.updateContent(n);
            }
        }

        public void titleExchanged(Dockable dockable, DockTitle dockTitle) {
        }
    }

    private class VisibleListener
    extends DockStationAdapter
    implements ChangeListener {
        private VisibleListener() {
        }

        public void dockableVisibiltySet(DockStation dockStation, Dockable dockable, boolean bl) {
            StackDockStation.this.visibility.fire();
        }

        public void stateChanged(ChangeEvent changeEvent) {
            DockController dockController = StackDockStation.this.getController();
            if (dockController != null) {
                Dockable dockable = StackDockStation.this.getFrontDockable();
                if (dockable != null) {
                    dockController.setFocusedDockable(dockable, false);
                }
                StackDockStation.this.fireDockableSelected();
            }
            StackDockStation.this.visibility.fire();
        }
    }
}

