/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.frontend;

import bibliothek.gui.DockFrontend;
import bibliothek.gui.DockStation;
import bibliothek.gui.Dockable;
import bibliothek.gui.dock.DockElement;
import bibliothek.gui.dock.DockFactory;
import bibliothek.gui.dock.frontend.DockFrontendInternals;
import bibliothek.gui.dock.frontend.LayoutChangeStrategy;
import bibliothek.gui.dock.frontend.MissingDockableStrategy;
import bibliothek.gui.dock.frontend.RegisteringDockFactory;
import bibliothek.gui.dock.frontend.Setting;
import bibliothek.gui.dock.layout.AdjacentDockFactory;
import bibliothek.gui.dock.layout.DockLayoutComposition;
import bibliothek.gui.dock.layout.DockSituation;
import bibliothek.gui.dock.layout.DockSituationIgnore;
import bibliothek.gui.dock.layout.DockableProperty;
import bibliothek.gui.dock.layout.DockablePropertyFactory;
import bibliothek.gui.dock.layout.PredefinedDockSituation;
import bibliothek.gui.dock.layout.PropertyTransformer;
import bibliothek.util.xml.XException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultLayoutChangeStrategy
implements LayoutChangeStrategy {
    @Override
    public boolean setLayout(DockFrontendInternals dockFrontendInternals, Setting setting, boolean bl) throws IOException, XException {
        SettingAccess settingAccess;
        DockSituation dockSituation = this.createSituation(dockFrontendInternals, bl, true);
        DockSituationIgnore dockSituationIgnore = dockSituation.getIgnore();
        if (dockSituationIgnore == null) {
            dockSituationIgnore = new DockSituationIgnore(){

                public boolean ignoreChildren(DockStation dockStation) {
                    return false;
                }

                public boolean ignoreElement(DockElement dockElement) {
                    return false;
                }
            };
        }
        if (this.approveClosing(dockFrontendInternals, dockSituation, settingAccess = this.createAccess(dockFrontendInternals, setting)) == null) {
            return false;
        }
        dockFrontendInternals.clean(dockSituationIgnore);
        this.applyLayout(dockFrontendInternals, dockSituation, settingAccess, bl);
        this.applyInvisibleLayout(dockFrontendInternals, dockSituation, settingAccess);
        return true;
    }

    protected SettingAccess createAccess(DockFrontendInternals dockFrontendInternals, Setting setting) {
        return new SettingAccess(setting);
    }

    @Override
    public DockSituation createSituation(DockFrontendInternals dockFrontendInternals, boolean bl) {
        return this.createSituation(dockFrontendInternals, bl, false);
    }

    protected DockSituation createSituation(final DockFrontendInternals dockFrontendInternals, final boolean bl, boolean bl2) {
        PredefinedDockSituation predefinedDockSituation = new PredefinedDockSituation(){

            protected boolean shouldLayout(DockElement dockElement) {
                DockFrontend.DockInfo dockInfo;
                Dockable dockable;
                if (bl && (dockable = dockElement.asDockable()) != null && (dockInfo = dockFrontendInternals.getInfo(dockable)) != null) {
                    dockInfo.isEntryLayout();
                }
                return true;
            }
        };
        for (DockFrontend.DockInfo object : dockFrontendInternals.getDockables()) {
            if (object.getDockable() == null) continue;
            predefinedDockSituation.put("dockable" + object.getKey(), object.getDockable());
        }
        for (DockFrontend.RootInfo rootInfo : dockFrontendInternals.getRoots()) {
            predefinedDockSituation.put("root" + rootInfo.getName(), rootInfo.getStation());
        }
        for (DockFactory<?, ?> dockFactory : dockFrontendInternals.getDockFactories()) {
            predefinedDockSituation.add(dockFactory);
        }
        for (DockFactory<?, ?> dockFactory : dockFrontendInternals.getBackupDockFactories()) {
            predefinedDockSituation.addBackup(new RegisteringDockFactory(dockFrontendInternals.getFrontend(), dockFactory));
        }
        for (AdjacentDockFactory<?> adjacentDockFactory : dockFrontendInternals.getAdjacentDockFactories()) {
            predefinedDockSituation.addAdjacent(adjacentDockFactory);
        }
        if (bl) {
            predefinedDockSituation.setIgnore(dockFrontendInternals.getFrontend().getIgnoreForEntry());
        } else {
            predefinedDockSituation.setIgnore(dockFrontendInternals.getFrontend().getIgnoreForFinal());
        }
        return predefinedDockSituation;
    }

    @Override
    public PropertyTransformer createTransformer(DockFrontendInternals dockFrontendInternals) {
        PropertyTransformer propertyTransformer = new PropertyTransformer();
        for (DockablePropertyFactory dockablePropertyFactory : dockFrontendInternals.getPropertyFactories()) {
            propertyTransformer.addFactory(dockablePropertyFactory);
        }
        return propertyTransformer;
    }

    protected void applyLayout(DockFrontendInternals dockFrontendInternals, DockSituation dockSituation, SettingAccess settingAccess, boolean bl) throws IOException, XException {
        DockFrontend dockFrontend = dockFrontendInternals.getFrontend();
        MissingDockableStrategy missingDockableStrategy = dockFrontendInternals.getMissingDockableStrategy();
        for (DockFrontend.RootInfo rootInfo : dockFrontendInternals.getRoots()) {
            Object object;
            Object object2;
            DockLayoutComposition dockLayoutComposition = settingAccess.getRoot(rootInfo.getName());
            if (dockLayoutComposition == null) continue;
            Map<String, DockableProperty> map = this.listEstimateLocations(dockSituation, dockLayoutComposition = dockSituation.fillMissing(dockLayoutComposition));
            if (map != null) {
                object2 = map.entrySet().iterator();
                while (object2.hasNext()) {
                    Map.Entry entry = (Map.Entry)object2.next();
                    String string = (String)entry.getKey();
                    object = dockFrontendInternals.getInfo(string);
                    if (object == null && missingDockableStrategy.shouldStoreShown(string)) {
                        dockFrontend.addEmpty(string);
                        object = dockFrontendInternals.getInfo(string);
                    }
                    if (object == null) continue;
                    ((DockFrontend.DockInfo)object).setLocation(rootInfo.getName(), (DockableProperty)entry.getValue());
                    ((DockFrontend.DockInfo)object).setShown(true);
                }
            }
            if ((object2 = this.listLayouts(dockSituation, dockLayoutComposition)) != null) {
                for (Map.Entry entry : object2.entrySet()) {
                    object = (String)entry.getKey();
                    DockFrontend.DockInfo dockInfo = dockFrontendInternals.getInfo((String)object);
                    if (dockInfo == null && missingDockableStrategy.shouldStoreShown((String)object)) {
                        dockFrontend.addEmpty((String)object);
                        dockInfo = dockFrontendInternals.getInfo((String)object);
                    }
                    if (dockInfo == null) continue;
                    dockInfo.setShown(true);
                    if (bl && !dockInfo.isEntryLayout()) continue;
                    dockInfo.setLayout((DockLayoutComposition)entry.getValue());
                }
            }
            dockSituation.convert(dockLayoutComposition);
        }
    }

    protected void applyInvisibleLayout(DockFrontendInternals dockFrontendInternals, DockSituation dockSituation, SettingAccess settingAccess) throws IOException, XException {
        DockFrontend dockFrontend = dockFrontendInternals.getFrontend();
        MissingDockableStrategy missingDockableStrategy = dockFrontendInternals.getMissingDockableStrategy();
        int n = settingAccess.getInvisibleCount();
        for (int i = 0; i < n; ++i) {
            String string = settingAccess.getInvisibleKey(i);
            DockFrontend.DockInfo dockInfo = dockFrontendInternals.getInfo(string);
            if (dockInfo == null && missingDockableStrategy.shouldStoreHidden(string)) {
                dockFrontend.addEmpty(string);
                dockInfo = dockFrontendInternals.getInfo(string);
            }
            if (dockInfo == null) continue;
            dockInfo.setShown(false);
            dockInfo.setLocation(settingAccess.getInvisibleRoot(i), settingAccess.getInvisibleLocation(i));
            DockLayoutComposition dockLayoutComposition = settingAccess.getInvisibleLayout(i);
            if (dockLayoutComposition == null) continue;
            dockLayoutComposition = dockSituation.fillMissing(dockLayoutComposition);
            if (dockInfo.getDockable() != null) {
                dockSituation.convert(dockLayoutComposition);
                dockLayoutComposition = null;
            }
            dockInfo.setLayout(dockLayoutComposition);
        }
    }

    protected Map<String, DockLayoutComposition> listLayouts(DockSituation dockSituation, DockLayoutComposition dockLayoutComposition) {
        if (dockSituation instanceof PredefinedDockSituation) {
            Map<String, DockLayoutComposition> map = ((PredefinedDockSituation)dockSituation).listLayouts(dockLayoutComposition, true);
            HashMap<String, DockLayoutComposition> hashMap = new HashMap<String, DockLayoutComposition>();
            for (Map.Entry<String, DockLayoutComposition> entry : map.entrySet()) {
                String string = entry.getKey();
                if (string.startsWith("dockable")) {
                    hashMap.put(string.substring("dockable".length()), entry.getValue());
                    continue;
                }
                if (string.startsWith("root")) {
                    hashMap.put(string.substring("root".length()), entry.getValue());
                    continue;
                }
                hashMap.put(string, entry.getValue());
            }
            return hashMap;
        }
        return null;
    }

    protected Map<String, DockableProperty> listEstimateLocations(DockSituation dockSituation, DockLayoutComposition dockLayoutComposition) {
        if (dockSituation instanceof PredefinedDockSituation) {
            Map<String, DockableProperty> map = ((PredefinedDockSituation)dockSituation).listEstimatedLocations(dockLayoutComposition, true);
            HashMap<String, DockableProperty> hashMap = new HashMap<String, DockableProperty>();
            for (Map.Entry<String, DockableProperty> entry : map.entrySet()) {
                String string = entry.getKey();
                if (string.startsWith("dockable")) {
                    hashMap.put(string.substring("dockable".length()), entry.getValue());
                    continue;
                }
                if (string.startsWith("root")) {
                    hashMap.put(string.substring("root".length()), entry.getValue());
                    continue;
                }
                hashMap.put(string, entry.getValue());
            }
            return hashMap;
        }
        return null;
    }

    @Override
    public void estimateLocations(DockFrontendInternals dockFrontendInternals, DockSituation dockSituation, DockLayoutComposition dockLayoutComposition) {
        if (dockSituation instanceof PredefinedDockSituation) {
            ((PredefinedDockSituation)dockSituation).estimateLocations(dockLayoutComposition);
        }
    }

    protected Collection<Dockable> approveClosing(DockFrontendInternals dockFrontendInternals, DockSituation dockSituation, SettingAccess settingAccess) {
        HashSet<Dockable> hashSet = new HashSet<Dockable>();
        for (DockFrontend.RootInfo rootInfo : dockFrontendInternals.getRoots()) {
            Set<Dockable> set;
            DockLayoutComposition dockLayoutComposition = settingAccess.getRoot(rootInfo.getName());
            if (dockLayoutComposition == null || (set = this.estimateVisible(dockFrontendInternals, dockSituation, dockLayoutComposition)) == null) continue;
            hashSet.addAll(set);
        }
        Collection<Dockable> collection = this.getClosingDockables(dockFrontendInternals, hashSet);
        if (!collection.isEmpty() && !dockFrontendInternals.getVetos().expectToHide(collection, true)) {
            return null;
        }
        return collection;
    }

    protected Collection<Dockable> getClosingDockables(DockFrontendInternals dockFrontendInternals, Set<Dockable> set) {
        ArrayList<Dockable> arrayList = new ArrayList<Dockable>();
        for (DockFrontend.DockInfo dockInfo : dockFrontendInternals.getDockables()) {
            Dockable dockable = dockInfo.getDockable();
            if (dockable == null || !dockInfo.isHideable() || set.contains(dockable)) continue;
            arrayList.add(dockInfo.getDockable());
        }
        return arrayList;
    }

    protected Set<Dockable> estimateVisible(DockFrontendInternals dockFrontendInternals, DockSituation dockSituation, DockLayoutComposition dockLayoutComposition) {
        if (dockSituation instanceof PredefinedDockSituation) {
            HashSet<Dockable> hashSet = new HashSet<Dockable>();
            for (DockFrontend.DockInfo dockInfo : dockFrontendInternals.getDockables()) {
                Dockable dockable = dockInfo.getDockable();
                if (dockable == null) continue;
                hashSet.add(dockable);
            }
            PredefinedDockSituation predefinedDockSituation = (PredefinedDockSituation)dockSituation;
            Set<Dockable> set = predefinedDockSituation.listVisible(hashSet, dockLayoutComposition);
            return set;
        }
        return null;
    }

    protected class SettingAccess {
        private Setting setting;

        public SettingAccess(Setting setting) {
            this.setting = setting;
        }

        public Setting getSetting() {
            return this.setting;
        }

        public DockLayoutComposition getRoot(String string) {
            return this.setting.getRoot(string);
        }

        public String[] getRootKeys() {
            return this.setting.getRootKeys();
        }

        public int getInvisibleCount() {
            return this.setting.getInvisibleCount();
        }

        public String getInvisibleKey(int n) {
            return this.setting.getInvisibleKey(n);
        }

        public String getInvisibleRoot(int n) {
            return this.setting.getInvisibleRoot(n);
        }

        public DockableProperty getInvisibleLocation(int n) {
            return this.setting.getInvisibleLocation(n);
        }

        public DockLayoutComposition getInvisibleLayout(int n) {
            return this.setting.getInvisibleLayout(n);
        }

        public void fillMissing(DockSituation dockSituation) {
            this.setting.fillMissing(dockSituation);
        }
    }
}

