/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.layout;

import bibliothek.gui.dock.layout.DockableProperty;
import bibliothek.gui.dock.layout.DockablePropertyFactory;
import bibliothek.gui.dock.station.flap.FlapDockPropertyFactory;
import bibliothek.gui.dock.station.screen.ScreenDockPropertyFactory;
import bibliothek.gui.dock.station.split.SplitDockFullScreenPropertyFactory;
import bibliothek.gui.dock.station.split.SplitDockPathPropertyFactory;
import bibliothek.gui.dock.station.split.SplitDockPlaceholderPropertyFactory;
import bibliothek.gui.dock.station.split.SplitDockPropertyFactory;
import bibliothek.gui.dock.station.stack.StackDockPropertyFactory;
import bibliothek.util.Version;
import bibliothek.util.xml.XElement;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;

public class PropertyTransformer {
    private Map<String, DockablePropertyFactory> factories = new HashMap<String, DockablePropertyFactory>();

    public PropertyTransformer() {
        this(SplitDockPropertyFactory.FACTORY, SplitDockPathPropertyFactory.FACTORY, SplitDockPlaceholderPropertyFactory.FACTORY, SplitDockFullScreenPropertyFactory.FACTORY, StackDockPropertyFactory.FACTORY, FlapDockPropertyFactory.FACTORY, ScreenDockPropertyFactory.FACTORY);
    }

    public PropertyTransformer(DockablePropertyFactory ... dockablePropertyFactoryArray) {
        for (DockablePropertyFactory dockablePropertyFactory : dockablePropertyFactoryArray) {
            this.factories.put(dockablePropertyFactory.getID(), dockablePropertyFactory);
        }
    }

    public void addFactory(DockablePropertyFactory dockablePropertyFactory) {
        this.factories.put(dockablePropertyFactory.getID(), dockablePropertyFactory);
    }

    public void write(DockableProperty dockableProperty, DataOutputStream dataOutputStream) throws IOException {
        Version.write(dataOutputStream, Version.VERSION_1_0_4);
        int n = 0;
        for (DockableProperty dockableProperty2 = dockableProperty; dockableProperty2 != null; dockableProperty2 = dockableProperty2.getSuccessor()) {
            ++n;
        }
        dataOutputStream.writeInt(n);
        while (dockableProperty != null) {
            dataOutputStream.writeUTF(dockableProperty.getFactoryID());
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            DataOutputStream dataOutputStream2 = new DataOutputStream(byteArrayOutputStream);
            dockableProperty.store(dataOutputStream2);
            dataOutputStream2.close();
            byte[] byArray = byteArrayOutputStream.toByteArray();
            dataOutputStream.writeInt(byArray.length);
            dataOutputStream.write(byArray);
            dockableProperty = dockableProperty.getSuccessor();
        }
    }

    public DockableProperty read(DataInputStream dataInputStream) throws IOException {
        Version version = Version.read(dataInputStream);
        version.checkCurrent();
        int n = dataInputStream.readInt();
        DockableProperty dockableProperty = null;
        DockableProperty dockableProperty2 = null;
        for (int i = 0; i < n; ++i) {
            int n2;
            String string = dataInputStream.readUTF();
            DockablePropertyFactory dockablePropertyFactory = this.factories.get(string);
            if (dockablePropertyFactory == null) {
                throw new IOException("Unknown factory-id: " + string);
            }
            DockableProperty dockableProperty3 = dockablePropertyFactory.createProperty();
            int n3 = dataInputStream.readInt();
            byte[] byArray = new byte[n3];
            for (int j = 0; j < n3; j += n2) {
                n2 = dataInputStream.read(byArray, j, n3 - j);
                if (n2 >= 0) continue;
                throw new EOFException();
            }
            DataInputStream dataInputStream2 = new DataInputStream(new ByteArrayInputStream(byArray));
            dockableProperty3.load(dataInputStream2);
            dataInputStream2.close();
            if (dockableProperty2 == null) {
                dockableProperty2 = dockableProperty3;
                dockableProperty = dockableProperty3;
                continue;
            }
            dockableProperty.setSuccessor(dockableProperty3);
            dockableProperty = dockableProperty3;
        }
        return dockableProperty2;
    }

    public void writeXML(DockableProperty dockableProperty, XElement xElement) {
        while (dockableProperty != null) {
            XElement xElement2 = xElement.addElement("property");
            xElement2.addString("factory", dockableProperty.getFactoryID());
            dockableProperty.store(xElement2);
            dockableProperty = dockableProperty.getSuccessor();
        }
    }

    public DockableProperty readXML(XElement xElement) {
        DockableProperty dockableProperty = null;
        DockableProperty dockableProperty2 = null;
        for (XElement xElement2 : xElement.getElements("property")) {
            DockablePropertyFactory dockablePropertyFactory = this.factories.get(xElement2.getString("factory"));
            if (dockablePropertyFactory == null) {
                throw new IllegalArgumentException("Missing factory: " + xElement2.getString("factory"));
            }
            DockableProperty dockableProperty3 = dockablePropertyFactory.createProperty();
            dockableProperty3.load(xElement2);
            if (dockableProperty2 == null) {
                dockableProperty2 = dockableProperty3;
                dockableProperty = dockableProperty3;
                continue;
            }
            dockableProperty2.setSuccessor(dockableProperty3);
            dockableProperty2 = dockableProperty3;
        }
        return dockableProperty;
    }
}

