/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.station.stack;

import bibliothek.gui.DockController;
import bibliothek.gui.Dockable;
import bibliothek.gui.dock.DockFactory;
import bibliothek.gui.dock.StackDockStation;
import bibliothek.gui.dock.layout.DockLayoutInfo;
import bibliothek.gui.dock.layout.LocationEstimationMap;
import bibliothek.gui.dock.station.stack.RetroStackDockStationLayout;
import bibliothek.gui.dock.station.stack.StackDockProperty;
import bibliothek.gui.dock.station.stack.StackDockStationLayout;
import bibliothek.gui.dock.station.support.ConvertedPlaceholderListItem;
import bibliothek.gui.dock.station.support.PlaceholderList;
import bibliothek.gui.dock.station.support.PlaceholderListItem;
import bibliothek.gui.dock.station.support.PlaceholderListItemAdapter;
import bibliothek.gui.dock.station.support.PlaceholderMap;
import bibliothek.gui.dock.station.support.PlaceholderStrategy;
import bibliothek.util.Path;
import bibliothek.util.Version;
import bibliothek.util.xml.XElement;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StackDockStationFactory
implements DockFactory<StackDockStation, StackDockStationLayout> {
    public static final String ID = "StackDockStationFactory";

    @Override
    public String getID() {
        return ID;
    }

    @Override
    public StackDockStationLayout getLayout(StackDockStation stackDockStation, Map<Dockable, Integer> map) {
        Dockable dockable = stackDockStation.getFrontDockable();
        int n = -1;
        if (dockable != null) {
            n = stackDockStation.indexOf(dockable);
        }
        PlaceholderMap placeholderMap = stackDockStation.getPlaceholders(map);
        return new StackDockStationLayout(n, placeholderMap);
    }

    @Override
    public void estimateLocations(StackDockStationLayout stackDockStationLayout, final LocationEstimationMap locationEstimationMap) {
        if (stackDockStationLayout instanceof RetroStackDockStationLayout) {
            RetroStackDockStationLayout retroStackDockStationLayout = (RetroStackDockStationLayout)stackDockStationLayout;
            for (int n : retroStackDockStationLayout.getChildren()) {
                DockLayoutInfo dockLayoutInfo = locationEstimationMap.getChild(n);
                if (dockLayoutInfo == null) continue;
                StackDockProperty stackDockProperty = new StackDockProperty(n, dockLayoutInfo.getPlaceholder());
                dockLayoutInfo.setLocation(stackDockProperty);
            }
        } else {
            PlaceholderList.simulatedRead(stackDockStationLayout.getPlaceholders(), new PlaceholderListItemAdapter<PlaceholderListItem>(){

                @Override
                public PlaceholderListItem convert(ConvertedPlaceholderListItem convertedPlaceholderListItem) {
                    int n = convertedPlaceholderListItem.getInt("id");
                    int n2 = convertedPlaceholderListItem.getInt("index");
                    Path path = null;
                    if (convertedPlaceholderListItem.contains("placeholder")) {
                        path = new Path(convertedPlaceholderListItem.getString("placeholder"));
                    }
                    StackDockProperty stackDockProperty = new StackDockProperty(n2, path);
                    locationEstimationMap.getChild(n).setLocation(stackDockProperty);
                    int n3 = locationEstimationMap.getSubChildCount(n);
                    for (int i = 0; i < n3; ++i) {
                        DockLayoutInfo dockLayoutInfo = locationEstimationMap.getSubChild(n, i);
                        dockLayoutInfo.setLocation(new StackDockProperty(n, dockLayoutInfo.getPlaceholder()));
                    }
                    return null;
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setLayout(StackDockStation stackDockStation, StackDockStationLayout stackDockStationLayout, Map<Integer, Dockable> map) {
        DockController dockController = stackDockStation.getController();
        try {
            if (dockController != null) {
                dockController.freezeLayout();
            }
            for (int i = stackDockStation.getDockableCount() - 1; i >= 0; --i) {
                stackDockStation.remove(i);
            }
            if (stackDockStationLayout instanceof RetroStackDockStationLayout) {
                RetroStackDockStationLayout retroStackDockStationLayout = (RetroStackDockStationLayout)stackDockStationLayout;
                for (int n : retroStackDockStationLayout.getChildren()) {
                    Dockable dockable = map.get(n);
                    if (dockable == null) continue;
                    stackDockStation.drop(dockable);
                }
            } else {
                stackDockStation.setPlaceholders(stackDockStationLayout.getPlaceholders(), map);
            }
            Dockable dockable = map.get(stackDockStationLayout.getSelected());
            if (dockable != null) {
                stackDockStation.setFrontDockable(dockable);
            }
        }
        finally {
            if (dockController != null) {
                dockController.meltLayout();
            }
        }
    }

    @Override
    public void setLayout(StackDockStation stackDockStation, StackDockStationLayout stackDockStationLayout) {
    }

    @Override
    public StackDockStation layout(StackDockStationLayout stackDockStationLayout, Map<Integer, Dockable> map) {
        StackDockStation stackDockStation = this.createStation();
        this.setLayout(stackDockStation, stackDockStationLayout, map);
        return stackDockStation;
    }

    @Override
    public StackDockStation layout(StackDockStationLayout stackDockStationLayout) {
        StackDockStation stackDockStation = this.createStation();
        this.setLayout(stackDockStation, stackDockStationLayout);
        return stackDockStation;
    }

    @Override
    public void write(StackDockStationLayout stackDockStationLayout, DataOutputStream dataOutputStream) throws IOException {
        if (stackDockStationLayout instanceof RetroStackDockStationLayout) {
            RetroStackDockStationLayout retroStackDockStationLayout = (RetroStackDockStationLayout)stackDockStationLayout;
            Version.write(dataOutputStream, Version.VERSION_1_0_4);
            dataOutputStream.writeInt(stackDockStationLayout.getSelected());
            dataOutputStream.writeInt(retroStackDockStationLayout.getChildren().length);
            for (int n : retroStackDockStationLayout.getChildren()) {
                dataOutputStream.writeInt(n);
            }
        } else {
            Version.write(dataOutputStream, Version.VERSION_1_0_8);
            dataOutputStream.writeInt(stackDockStationLayout.getSelected());
            stackDockStationLayout.getPlaceholders().write(dataOutputStream);
        }
    }

    @Override
    public StackDockStationLayout read(DataInputStream dataInputStream, PlaceholderStrategy placeholderStrategy) throws IOException {
        boolean bl;
        Version version = Version.read(dataInputStream);
        version.checkCurrent();
        boolean bl2 = bl = Version.VERSION_1_0_8.compareTo(version) <= 0;
        if (bl) {
            int n = dataInputStream.readInt();
            PlaceholderMap placeholderMap = new PlaceholderMap(dataInputStream, placeholderStrategy);
            placeholderMap.setPlaceholderStrategy(null);
            return new StackDockStationLayout(n, placeholderMap);
        }
        int n = dataInputStream.readInt();
        int n2 = dataInputStream.readInt();
        int[] nArray = new int[n2];
        for (int i = 0; i < n2; ++i) {
            nArray[i] = dataInputStream.readInt();
        }
        return new RetroStackDockStationLayout(n, nArray);
    }

    @Override
    public void write(StackDockStationLayout stackDockStationLayout, XElement xElement) {
        if (stackDockStationLayout.getSelected() >= 0) {
            xElement.addElement("selected").setInt(stackDockStationLayout.getSelected());
        }
        if (stackDockStationLayout instanceof RetroStackDockStationLayout) {
            RetroStackDockStationLayout retroStackDockStationLayout = (RetroStackDockStationLayout)stackDockStationLayout;
            XElement xElement2 = xElement.addElement("children");
            for (int n : retroStackDockStationLayout.getChildren()) {
                xElement2.addElement("child").addInt("id", n);
            }
        } else {
            stackDockStationLayout.getPlaceholders().write(xElement.addElement("placeholders"));
        }
    }

    @Override
    public StackDockStationLayout read(XElement xElement, PlaceholderStrategy placeholderStrategy) {
        XElement xElement2;
        XElement xElement3 = xElement.getElement("selected");
        int n = -1;
        if (xElement3 != null) {
            n = xElement3.getInt();
        }
        if ((xElement2 = xElement.getElement("placeholders")) == null) {
            int[] nArray;
            XElement xElement4 = xElement.getElement("children");
            if (xElement4 != null) {
                XElement[] xElementArray = xElement4.getElements("child");
                nArray = new int[xElementArray.length];
                int n2 = xElementArray.length;
                for (int i = 0; i < n2; ++i) {
                    nArray[i] = xElementArray[i].getInt("id");
                }
            } else {
                nArray = new int[]{};
            }
            return new RetroStackDockStationLayout(n, nArray);
        }
        PlaceholderMap placeholderMap = new PlaceholderMap(xElement2, placeholderStrategy);
        return new StackDockStationLayout(n, placeholderMap);
    }

    protected StackDockStation createStation() {
        return new StackDockStation();
    }
}

