/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.station.stack.tab;

import bibliothek.gui.DockController;
import bibliothek.gui.Dockable;
import bibliothek.gui.dock.station.stack.tab.LonelyTabPaneComponent;
import bibliothek.gui.dock.station.stack.tab.Tab;
import bibliothek.gui.dock.station.stack.tab.TabLayoutManager;
import bibliothek.gui.dock.station.stack.tab.TabMenu;
import bibliothek.gui.dock.station.stack.tab.TabPane;
import bibliothek.gui.dock.station.stack.tab.TabPaneListener;
import bibliothek.gui.dock.station.stack.tab.layouting.TabPlacement;
import bibliothek.gui.dock.util.PropertyValue;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractTabPane<T extends Tab, M extends TabMenu, I extends LonelyTabPaneComponent>
implements TabPane {
    private PropertyValue<TabLayoutManager> layoutManager = new PropertyValue<TabLayoutManager>(TabPane.LAYOUT_MANAGER){

        @Override
        protected void valueChanged(TabLayoutManager tabLayoutManager, TabLayoutManager tabLayoutManager2) {
            if (tabLayoutManager != null) {
                tabLayoutManager.uninstall(AbstractTabPane.this);
            }
            if (tabLayoutManager2 != null) {
                tabLayoutManager2.install(AbstractTabPane.this);
            }
        }
    };
    private DockController controller;
    private List<Dockable> dockables = new ArrayList<Dockable>();
    private Dockable selection;
    private Map<Dockable, T> tabs = new HashMap<Dockable, T>();
    private List<M> menus = new ArrayList<M>();
    private Map<Dockable, M> menuPosition = new HashMap<Dockable, M>();
    private List<TabPaneListener> listeners = new ArrayList<TabPaneListener>();
    private I info;
    private TabPlacement tabPlacement = TabPlacement.TOP_OF_DOCKABLE;

    public void setController(DockController dockController) {
        this.controller = dockController;
        this.layoutManager.setProperties(dockController);
    }

    @Override
    public DockController getController() {
        return this.controller;
    }

    public void setTabPlacement(TabPlacement tabPlacement) {
        if (tabPlacement == null) {
            throw new IllegalArgumentException("tab placement must not be null");
        }
        this.tabPlacement = tabPlacement;
        this.revalidate();
    }

    @Override
    public TabPlacement getTabPlacement() {
        return this.tabPlacement;
    }

    public void doLayout() {
        TabLayoutManager tabLayoutManager = this.layoutManager.getValue();
        if (tabLayoutManager != null) {
            tabLayoutManager.layout(this);
        }
    }

    public Dimension getMinimumSize() {
        TabLayoutManager tabLayoutManager = this.layoutManager.getValue();
        if (tabLayoutManager != null) {
            return tabLayoutManager.getMinimumSize(this);
        }
        return new Dimension(1, 1);
    }

    public Dimension getPreferredSize() {
        TabLayoutManager tabLayoutManager = this.layoutManager.getValue();
        if (tabLayoutManager != null) {
            return tabLayoutManager.getPreferredSize(this);
        }
        return new Dimension(1, 1);
    }

    public void revalidate() {
        this.doLayout();
    }

    @Override
    public void addTabPaneListener(TabPaneListener tabPaneListener) {
        this.listeners.add(tabPaneListener);
    }

    @Override
    public void removeTabPaneListener(TabPaneListener tabPaneListener) {
        this.listeners.remove(tabPaneListener);
    }

    protected TabPaneListener[] listeners() {
        return this.listeners.toArray(new TabPaneListener[this.listeners.size()]);
    }

    protected void fireSelectionChanged() {
        for (TabPaneListener tabPaneListener : this.listeners()) {
            tabPaneListener.selectionChanged(this);
        }
    }

    protected void fireAdded(Dockable dockable) {
        for (TabPaneListener tabPaneListener : this.listeners()) {
            tabPaneListener.added(this, dockable);
        }
    }

    protected void fireRemoved(Dockable dockable) {
        for (TabPaneListener tabPaneListener : this.listeners()) {
            tabPaneListener.removed(this, dockable);
        }
    }

    protected void fireInfoComponentChanged(I i, I i2) {
        for (TabPaneListener tabPaneListener : this.listeners()) {
            tabPaneListener.infoComponentChanged(this, (LonelyTabPaneComponent)i, (LonelyTabPaneComponent)i2);
        }
    }

    public TabLayoutManager getLayoutManager() {
        return this.layoutManager.getValue();
    }

    public void setLayoutManager(TabLayoutManager tabLayoutManager) {
        this.layoutManager.setValue(tabLayoutManager);
    }

    public void insert(int n, Dockable dockable) {
        int n2 = this.getDockableCount();
        this.dockables.add(n, dockable);
        this.fireAdded(dockable);
        if (n2 == 0) {
            this.setSelectedDockable(dockable);
        }
        this.revalidate();
    }

    public void move(int n, int n2) {
        if (n2 < 0 || n2 >= this.getDockableCount()) {
            throw new ArrayIndexOutOfBoundsException();
        }
        Dockable dockable = this.dockables.remove(n);
        this.cleanOut(dockable);
        this.dockables.add(n2, dockable);
        this.revalidate();
    }

    public void remove(int n) {
        Dockable dockable = this.dockables.remove(n);
        boolean bl = false;
        if (this.selection == dockable) {
            bl = true;
            this.setSelectedDockable(null);
        }
        this.cleanOut(dockable);
        this.fireRemoved(dockable);
        if (bl) {
            if (n >= this.getDockableCount()) {
                n = this.getDockableCount() - 1;
            }
            if (n >= 0) {
                this.setSelectedDockable(this.getDockable(n));
            }
        }
        this.revalidate();
    }

    public void removeAll() {
        for (Tab object : this.tabs.values()) {
            object.setPaneVisible(false);
            this.tabRemoved(object);
        }
        this.tabs.clear();
        for (Map.Entry entry : this.menuPosition.entrySet()) {
            this.removeFromMenu((TabMenu)entry.getValue(), (Dockable)entry.getKey());
        }
        this.menuPosition.clear();
        for (Dockable dockable : this.dockables) {
            this.fireRemoved(dockable);
        }
        this.setSelectedDockable(null);
        this.dockables.clear();
        this.revalidate();
    }

    public void discardComponentsAndRebuild() {
        for (Tab object : this.tabs.values()) {
            object.setPaneVisible(false);
            this.tabRemoved(object);
        }
        this.tabs.clear();
        for (Map.Entry entry : this.menuPosition.entrySet()) {
            this.removeFromMenu((TabMenu)entry.getValue(), (Dockable)entry.getKey());
        }
        this.menuPosition.clear();
        this.doLayout();
    }

    @Override
    public Dockable getSelectedDockable() {
        return this.selection;
    }

    public void setSelectedDockable(Dockable dockable) {
        if (this.selection != dockable) {
            this.selection = dockable;
            this.revalidate();
            this.fireSelectionChanged();
        }
    }

    @Override
    public Dockable[] getDockables() {
        return this.dockables.toArray(new Dockable[this.dockables.size()]);
    }

    public int getDockableCount() {
        return this.dockables.size();
    }

    public Dockable getDockable(int n) {
        return this.dockables.get(n);
    }

    public int indexOf(Dockable dockable) {
        return this.dockables.indexOf(dockable);
    }

    @Override
    public Tab[] getTabs() {
        ArrayList<Tab> arrayList = new ArrayList<Tab>();
        for (Tab tab : this.tabs.values()) {
            if (!tab.isPaneVisible()) continue;
            arrayList.add(tab);
        }
        return arrayList.toArray(new Tab[arrayList.size()]);
    }

    public int indexOfVisible(Tab tab) {
        int n = 0;
        int n2 = this.getDockableCount();
        for (int i = 0; i < n2; ++i) {
            Tab tab2 = (Tab)this.tabs.get(this.dockables.get(i));
            if (tab2 == null || !tab2.isPaneVisible()) continue;
            if (tab == tab2) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    public T getVisibleTab(int n) {
        if (n < 0) {
            throw new IllegalArgumentException("index to small");
        }
        int n2 = this.getDockableCount();
        for (int i = 0; i < n2; ++i) {
            Tab tab = (Tab)this.tabs.get(this.dockables.get(i));
            if (tab == null || !tab.isPaneVisible()) continue;
            if (n == 0) {
                return (T)tab;
            }
            --n;
        }
        return null;
    }

    public int getVisibleTabCount() {
        int n = 0;
        for (Tab tab : this.tabs.values()) {
            if (!tab.isPaneVisible()) continue;
            ++n;
        }
        return n;
    }

    public List<T> getTabsList() {
        return new ArrayList<T>(this.tabs.values());
    }

    public T getTab(Dockable dockable) {
        return (T)((Tab)this.tabs.get(dockable));
    }

    public T putOnTab(Dockable dockable) {
        if (dockable == null) {
            throw new IllegalArgumentException("dockable must not be null");
        }
        if (!this.dockables.contains(dockable)) {
            throw new IllegalArgumentException("dockable not child of this pane");
        }
        Tab tab = (Tab)this.tabs.get(dockable);
        if (tab == null) {
            tab = this.newTab(dockable);
            tab.setOrientation(this.getTabPlacement());
            this.tabs.put(dockable, tab);
        }
        tab.setPaneVisible(true);
        TabMenu tabMenu = (TabMenu)this.menuPosition.remove(dockable);
        if (tabMenu != null) {
            this.removeFromMenu(tabMenu, dockable);
        }
        return (T)tab;
    }

    @Override
    public Tab getOnTab(Dockable dockable) {
        if (dockable == null) {
            throw new IllegalArgumentException("dockable must not be null");
        }
        if (!this.dockables.contains(dockable)) {
            throw new IllegalArgumentException("dockable not child of this pane");
        }
        Tab tab = (Tab)this.tabs.get(dockable);
        if (tab == null) {
            tab = this.newTab(dockable);
            tab.setOrientation(this.getTabPlacement());
            this.tabs.put(dockable, tab);
        }
        return tab;
    }

    public void setInfoComponent(I i) {
        if (this.info != i) {
            if (this.info != null) {
                this.info.setPaneVisible(false);
            }
            I i2 = this.info;
            this.info = i;
            if (this.info != null) {
                this.info.setPaneVisible(true);
            }
            this.fireInfoComponentChanged(i2, i);
        }
    }

    public I getInfoComponent() {
        return this.info;
    }

    public List<M> getMenuList() {
        return new ArrayList<M>(this.menus);
    }

    public TabMenu[] getMenus() {
        return this.menus.toArray(new TabMenu[this.menus.size()]);
    }

    public M getMenu(Dockable dockable) {
        return (M)((TabMenu)this.menuPosition.get(dockable));
    }

    @Override
    public void putInMenu(TabMenu tabMenu, Dockable dockable) {
        if (dockable == null) {
            throw new IllegalArgumentException("dockables must not be null");
        }
        if (!this.dockables.contains(dockable)) {
            throw new IllegalArgumentException("not child of this pane: " + dockable);
        }
        if (tabMenu == null) {
            throw new IllegalArgumentException("menu is null");
        }
        if (!this.menus.contains(tabMenu)) {
            throw new IllegalArgumentException("menu not created by this pane");
        }
        TabMenu tabMenu2 = (TabMenu)this.menuPosition.get(dockable);
        if (tabMenu2 == tabMenu) {
            return;
        }
        if (tabMenu2 != null) {
            this.removeFromMenu(tabMenu2, dockable);
        }
        this.addToMenu(tabMenu, dockable);
        this.menuPosition.put(dockable, tabMenu);
        Tab tab = (Tab)this.tabs.get(dockable);
        if (tab != null) {
            tab.setPaneVisible(false);
        }
    }

    @Override
    public TabMenu createMenu() {
        M m = this.newMenu();
        this.menus.add(m);
        return m;
    }

    @Override
    public void destroyMenu(TabMenu tabMenu) {
        if (tabMenu == null) {
            throw new IllegalArgumentException("menu is null");
        }
        if (!this.menus.remove(tabMenu)) {
            throw new IllegalArgumentException("menu not created by this pane");
        }
        tabMenu.setPaneVisible(false);
        for (Dockable dockable : tabMenu.getDockables()) {
            this.menuPosition.remove(dockable);
        }
        this.menuRemoved(tabMenu);
    }

    protected abstract void addToMenu(M var1, Dockable var2);

    protected abstract void removeFromMenu(M var1, Dockable var2);

    private void cleanOut(Dockable dockable) {
        TabMenu tabMenu;
        Tab tab = (Tab)this.tabs.remove(dockable);
        if (tab != null) {
            tab.setPaneVisible(false);
            this.tabRemoved(tab);
        }
        if ((tabMenu = (TabMenu)this.menuPosition.remove(dockable)) != null) {
            this.removeFromMenu(tabMenu, dockable);
        }
    }

    protected abstract T newTab(Dockable var1);

    public abstract M newMenu();

    protected abstract void tabRemoved(T var1);

    protected abstract void menuRemoved(M var1);
}

