/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.station.support;

import bibliothek.gui.DockStation;
import bibliothek.gui.Dockable;
import bibliothek.gui.dock.perspective.PerspectiveDockable;
import bibliothek.gui.dock.perspective.PerspectiveStation;
import bibliothek.gui.dock.station.support.PerspectivePlaceholderListItemConverter;
import bibliothek.gui.dock.station.support.PlaceholderList;
import bibliothek.gui.dock.station.support.PlaceholderListItem;
import bibliothek.gui.dock.station.support.PlaceholderListItemConverter;
import bibliothek.gui.dock.station.support.PlaceholderMap;
import bibliothek.gui.dock.station.support.PlaceholderStrategy;
import bibliothek.gui.dock.station.support.PlaceholderStrategyListener;
import bibliothek.util.Path;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PerspectivePlaceholderList<P extends PlaceholderListItem<PerspectiveDockable>>
extends PlaceholderList<PerspectiveDockable, PerspectiveStation, P> {
    public PerspectivePlaceholderList() {
        this.init();
    }

    public PerspectivePlaceholderList(PlaceholderMap map) {
        this(map, new PerspectivePlaceholderListItemConverter());
    }

    public PerspectivePlaceholderList(PlaceholderMap map, PlaceholderListItemConverter<PerspectiveDockable, P> converter) {
        super(map, converter);
        this.init();
    }

    private void init() {
        this.setStrategy(new PlaceholderStrategy(){

            public void uninstall(DockStation station) {
            }

            public void removeListener(PlaceholderStrategyListener listener) {
            }

            public boolean isValidPlaceholder(Path placeholder) {
                return true;
            }

            public void install(DockStation station) {
            }

            public Path getPlaceholderFor(Dockable dockable) {
                return null;
            }

            public void addListener(PlaceholderStrategyListener listener) {
            }
        });
        this.bind();
    }

    public static <P extends PlaceholderListItem<PerspectiveDockable>> void simulatedRead(PlaceholderMap map, PlaceholderListItemConverter<PerspectiveDockable, P> converter) {
        PerspectivePlaceholderList<P> list = new PerspectivePlaceholderList<P>();
        list.read(map, converter, true);
    }

    public PlaceholderMap toMap() {
        return this.toMap(new PerspectivePlaceholderListItemConverter());
    }

    @Override
    protected Path getPlaceholder(PerspectiveDockable dockable) {
        return dockable.getPlaceholder();
    }

    @Override
    protected PlaceholderMap getPlaceholders(PerspectiveStation station) {
        return station.getPlaceholders();
    }

    @Override
    protected void setPlaceholders(PerspectiveStation station, PlaceholderMap map) {
        station.setPlaceholders(map);
    }

    @Override
    protected PerspectiveStation toStation(PerspectiveDockable dockable) {
        return dockable.asStation();
    }

    protected PerspectiveDockable[] getChildren(PerspectiveStation station) {
        PerspectiveDockable[] children = new PerspectiveDockable[station.getDockableCount()];
        for (int i = 0; i < children.length; ++i) {
            children[i] = station.getDockable(i);
        }
        return children;
    }

    @Override
    protected String toString(PerspectiveDockable dockable) {
        return dockable.toString();
    }
}

